/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop;

import cascading.CascadingException;
import cascading.tuple.StreamComparator;
import cascading.tuple.hadoop.TestText;
import cascading.tuple.hadoop.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Comparator;
import org.apache.hadoop.io.WritableUtils;

public class TestTextComparator
implements StreamComparator<BufferedInputStream>,
Comparator<TestText>,
Serializable {
    @Override
    public int compare(TestText lhs, TestText rhs) {
        if (lhs == rhs) {
            return 0;
        }
        if (lhs == null) {
            return -1;
        }
        if (rhs == null) {
            return 1;
        }
        if (lhs.value == null && rhs.value == null) {
            return 0;
        }
        if (lhs.value == null) {
            return -1;
        }
        if (rhs.value == null) {
            return 1;
        }
        return lhs.value.compareTo(rhs.value);
    }

    @Override
    public int compare(BufferedInputStream lhsStream, BufferedInputStream rhsStream) {
        try {
            if (lhsStream == null && rhsStream == null) {
                return 0;
            }
            if (lhsStream == null) {
                WritableUtils.readString((DataInput)new DataInputStream((InputStream)rhsStream));
                return -1;
            }
            if (rhsStream == null) {
                WritableUtils.readString((DataInput)new DataInputStream((InputStream)lhsStream));
                return 1;
            }
            String lhsString = WritableUtils.readString((DataInput)new DataInputStream((InputStream)lhsStream));
            String rhsString = WritableUtils.readString((DataInput)new DataInputStream((InputStream)rhsStream));
            if (lhsString == null && rhsString == null) {
                return 0;
            }
            if (lhsString == null) {
                return -1;
            }
            if (rhsString == null) {
                return 1;
            }
            return lhsString.compareTo(rhsString);
        }
        catch (IOException exception) {
            throw new CascadingException((Throwable)exception);
        }
    }
}

