/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.hadoop;

import cascading.PlatformTestCase;
import cascading.flow.Flow;
import cascading.flow.FlowConnectorProps;
import cascading.operation.Function;
import cascading.operation.regex.RegexSplitter;
import cascading.pipe.Checkpoint;
import cascading.pipe.Each;
import cascading.pipe.HashJoin;
import cascading.pipe.Pipe;
import cascading.platform.hadoop.BaseHadoopPlatform;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tap.hadoop.Hfs;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import data.InputData;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.junit.Test;

public class DistCacheTapPlatformTest
extends PlatformTestCase
implements Serializable {
    public DistCacheTapPlatformTest() {
        super(true);
    }

    @Test
    public void testHashJoinDistCacheTapRHS() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileLower);
        this.getPlatform().copyFromLocal(InputData.inputFileUpper);
        Tap sourceLower = this.getPlatform().getTextFile(new Fields(new Comparable[]{"offset", "line"}), InputData.inputFileLower);
        Tap sourceUpper = ((BaseHadoopPlatform)this.getPlatform()).getDistCacheTap((Hfs)this.getPlatform().getTextFile(new Fields(new Comparable[]{"offset", "line"}), InputData.inputFileUpper));
        HashMap<String, Tap> sources = new HashMap<String, Tap>();
        sources.put("lower", sourceLower);
        sources.put("upper", sourceUpper);
        Tap sink = this.getPlatform().getTextFile(new Fields(new Comparable[]{"line"}), this.getOutputPath(this.getTestName() + "join"), SinkMode.REPLACE);
        RegexSplitter splitter = new RegexSplitter(new Fields(new Comparable[]{"num", "char"}), " ");
        Each pipeLower = new Each(new Pipe("lower"), new Fields(new Comparable[]{"line"}), (Function)splitter);
        Each pipeUpper = new Each(new Pipe("upper"), new Fields(new Comparable[]{"line"}), (Function)splitter);
        HashJoin splice = new HashJoin((Pipe)pipeLower, new Fields(new Comparable[]{"num"}), (Pipe)pipeUpper, new Fields(new Comparable[]{"num"}), Fields.size((int)4));
        Map properties = this.getProperties();
        Flow flow = this.getPlatform().getFlowConnector(properties).connect("distcache test", sources, sink, (Pipe)splice);
        flow.complete();
        DistCacheTapPlatformTest.validateLength((Flow)flow, (int)5);
        List values = DistCacheTapPlatformTest.getSinkAsList((Flow)flow);
        DistCacheTapPlatformTest.assertTrue((boolean)values.contains(new Tuple(new Object[]{"1\ta\t1\tA"})));
        DistCacheTapPlatformTest.assertTrue((boolean)values.contains(new Tuple(new Object[]{"2\tb\t2\tB"})));
        DistCacheTapPlatformTest.assertTrue((boolean)values.contains(new Tuple(new Object[]{"3\tc\t3\tC"})));
        DistCacheTapPlatformTest.assertTrue((boolean)values.contains(new Tuple(new Object[]{"4\td\t4\tD"})));
        DistCacheTapPlatformTest.assertTrue((boolean)values.contains(new Tuple(new Object[]{"5\te\t5\tE"})));
    }

    @Test
    public void testHashJoinDistCacheTapLHS() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileLower);
        this.getPlatform().copyFromLocal(InputData.inputFileUpper);
        Tap sourceLower = ((BaseHadoopPlatform)this.getPlatform()).getDistCacheTap((Hfs)this.getPlatform().getTextFile(new Fields(new Comparable[]{"offset", "line"}), InputData.inputFileLower));
        Tap sourceUpper = this.getPlatform().getTextFile(new Fields(new Comparable[]{"offset", "line"}), InputData.inputFileUpper);
        HashMap<String, Tap> sources = new HashMap<String, Tap>();
        sources.put("lower", sourceLower);
        sources.put("upper", sourceUpper);
        Tap sink = this.getPlatform().getTextFile(new Fields(new Comparable[]{"line"}), this.getOutputPath(this.getTestName() + "join"), SinkMode.REPLACE);
        RegexSplitter splitter = new RegexSplitter(new Fields(new Comparable[]{"num", "char"}), " ");
        Each pipeLower = new Each(new Pipe("lower"), new Fields(new Comparable[]{"line"}), (Function)splitter);
        Each pipeUpper = new Each(new Pipe("upper"), new Fields(new Comparable[]{"line"}), (Function)splitter);
        HashJoin splice = new HashJoin((Pipe)pipeLower, new Fields(new Comparable[]{"num"}), (Pipe)pipeUpper, new Fields(new Comparable[]{"num"}), Fields.size((int)4));
        Map properties = this.getProperties();
        Flow flow = this.getPlatform().getFlowConnector(properties).connect("distcache test", sources, sink, (Pipe)splice);
        flow.complete();
        DistCacheTapPlatformTest.validateLength((Flow)flow, (int)5);
        List values = DistCacheTapPlatformTest.getSinkAsList((Flow)flow);
        DistCacheTapPlatformTest.assertTrue((boolean)values.contains(new Tuple(new Object[]{"1\ta\t1\tA"})));
        DistCacheTapPlatformTest.assertTrue((boolean)values.contains(new Tuple(new Object[]{"2\tb\t2\tB"})));
        DistCacheTapPlatformTest.assertTrue((boolean)values.contains(new Tuple(new Object[]{"3\tc\t3\tC"})));
        DistCacheTapPlatformTest.assertTrue((boolean)values.contains(new Tuple(new Object[]{"4\td\t4\tD"})));
        DistCacheTapPlatformTest.assertTrue((boolean)values.contains(new Tuple(new Object[]{"5\te\t5\tE"})));
    }

    @Test
    public void testHashJoinCheckpointWithDistCacheDecorator() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileLower);
        this.getPlatform().copyFromLocal(InputData.inputFileUpper);
        Tap sourceLower = this.getPlatform().getTextFile(new Fields(new Comparable[]{"offset", "line"}), InputData.inputFileLower);
        Tap sourceUpper = this.getPlatform().getTextFile(new Fields(new Comparable[]{"offset", "line"}), InputData.inputFileUpper);
        HashMap<String, Tap> sources = new HashMap<String, Tap>();
        sources.put("lower", sourceLower);
        sources.put("upper", sourceUpper);
        Tap sink = this.getPlatform().getTextFile(new Fields(new Comparable[]{"line"}), this.getOutputPath("join"), SinkMode.REPLACE);
        RegexSplitter splitter = new RegexSplitter(new Fields(new Comparable[]{"num", "char"}), " ");
        Each pipeLower = new Each(new Pipe("lower"), new Fields(new Comparable[]{"line"}), (Function)splitter);
        Each pipeUpper = new Each(new Pipe("upper"), new Fields(new Comparable[]{"line"}), (Function)splitter);
        pipeUpper = new Checkpoint((Pipe)pipeUpper);
        HashJoin splice = new HashJoin((Pipe)pipeLower, new Fields(new Comparable[]{"num"}), (Pipe)pipeUpper, new Fields(new Comparable[]{"num"}), Fields.size((int)4));
        Map properties = this.getProperties();
        FlowConnectorProps.setCheckpointTapDecoratorClass((Map)properties, (String)"cascading.tap.hadoop.DistCacheTap");
        Flow flow = this.getPlatform().getFlowConnector(properties).connect(sources, sink, (Pipe)splice);
        flow.complete();
        DistCacheTapPlatformTest.validateLength((Flow)flow, (int)5);
        List values = DistCacheTapPlatformTest.getSinkAsList((Flow)flow);
        DistCacheTapPlatformTest.assertTrue((boolean)values.contains(new Tuple(new Object[]{"1\ta\t1\tA"})));
        DistCacheTapPlatformTest.assertTrue((boolean)values.contains(new Tuple(new Object[]{"2\tb\t2\tB"})));
    }

    @Test
    public void testGlobSupport() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileLower);
        File dir = File.createTempFile("distcachetap", Long.toString(System.nanoTime()));
        if (dir.exists()) {
            if (dir.isDirectory()) {
                FileUtils.deleteDirectory((File)dir);
            } else {
                dir.delete();
            }
        }
        dir.mkdirs();
        String[] data = new String[]{"1 A", "2 B", "3 C", "4 D", "5 E"};
        for (int i = 0; i < 5; ++i) {
            FileWriter fw = new FileWriter(new File(dir.getAbsolutePath(), "upper_" + i + ".txt"));
            fw.write(data[i]);
            fw.close();
        }
        dir.deleteOnExit();
        this.getPlatform().copyFromLocal(dir.getAbsolutePath());
        Tap sourceLower = this.getPlatform().getTextFile(new Fields(new Comparable[]{"offset", "line"}), InputData.inputFileLower);
        Tap sourceUpper = ((BaseHadoopPlatform)this.getPlatform()).getDistCacheTap((Hfs)this.getPlatform().getTextFile(new Fields(new Comparable[]{"offset", "line"}), dir.getAbsolutePath() + "/*"));
        HashMap<String, Tap> sources = new HashMap<String, Tap>();
        sources.put("lower", sourceLower);
        sources.put("upper", sourceUpper);
        Tap sink = this.getPlatform().getTextFile(new Fields(new Comparable[]{"line"}), this.getOutputPath(this.getTestName() + "join"), SinkMode.REPLACE);
        RegexSplitter splitter = new RegexSplitter(new Fields(new Comparable[]{"num", "char"}), " ");
        Each pipeLower = new Each(new Pipe("lower"), new Fields(new Comparable[]{"line"}), (Function)splitter);
        Each pipeUpper = new Each(new Pipe("upper"), new Fields(new Comparable[]{"line"}), (Function)splitter);
        HashJoin splice = new HashJoin((Pipe)pipeLower, new Fields(new Comparable[]{"num"}), (Pipe)pipeUpper, new Fields(new Comparable[]{"num"}), Fields.size((int)4));
        Map properties = this.getProperties();
        Flow flow = this.getPlatform().getFlowConnector(properties).connect("distcache test", sources, sink, (Pipe)splice);
        flow.complete();
        DistCacheTapPlatformTest.validateLength((Flow)flow, (int)5);
        List values = DistCacheTapPlatformTest.getSinkAsList((Flow)flow);
        DistCacheTapPlatformTest.assertTrue((boolean)values.contains(new Tuple(new Object[]{"1\ta\t1\tA"})));
        DistCacheTapPlatformTest.assertTrue((boolean)values.contains(new Tuple(new Object[]{"2\tb\t2\tB"})));
        DistCacheTapPlatformTest.assertTrue((boolean)values.contains(new Tuple(new Object[]{"3\tc\t3\tC"})));
        DistCacheTapPlatformTest.assertTrue((boolean)values.contains(new Tuple(new Object[]{"4\td\t4\tD"})));
        DistCacheTapPlatformTest.assertTrue((boolean)values.contains(new Tuple(new Object[]{"5\te\t5\tE"})));
    }

    @Test
    public void testDirectory() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileLower);
        File dir = File.createTempFile("distcachetap", Long.toString(System.nanoTime()));
        if (dir.exists()) {
            if (dir.isDirectory()) {
                FileUtils.deleteDirectory((File)dir);
            } else {
                dir.delete();
            }
        }
        dir.mkdirs();
        String[] data = new String[]{"1 A", "2 B", "3 C", "4 D", "5 E"};
        FileWriter fw = new FileWriter(new File(dir.getAbsolutePath(), "upper.txt"));
        for (int i = 0; i < 5; ++i) {
            fw.write(data[i] + System.getProperty("line.separator"));
        }
        fw.close();
        this.getPlatform().copyFromLocal(dir.getAbsolutePath());
        dir.deleteOnExit();
        Tap sourceLower = this.getPlatform().getTextFile(new Fields(new Comparable[]{"offset", "line"}), InputData.inputFileLower);
        Tap sourceUpper = ((BaseHadoopPlatform)this.getPlatform()).getDistCacheTap((Hfs)this.getPlatform().getTextFile(new Fields(new Comparable[]{"offset", "line"}), dir.getAbsolutePath()));
        HashMap<String, Tap> sources = new HashMap<String, Tap>();
        sources.put("lower", sourceLower);
        sources.put("upper", sourceUpper);
        Tap sink = this.getPlatform().getTextFile(new Fields(new Comparable[]{"line"}), this.getOutputPath(this.getTestName() + "join"), SinkMode.REPLACE);
        RegexSplitter splitter = new RegexSplitter(new Fields(new Comparable[]{"num", "char"}), " ");
        Each pipeLower = new Each(new Pipe("lower"), new Fields(new Comparable[]{"line"}), (Function)splitter);
        Each pipeUpper = new Each(new Pipe("upper"), new Fields(new Comparable[]{"line"}), (Function)splitter);
        HashJoin splice = new HashJoin((Pipe)pipeLower, new Fields(new Comparable[]{"num"}), (Pipe)pipeUpper, new Fields(new Comparable[]{"num"}), Fields.size((int)4));
        Map properties = this.getProperties();
        Flow flow = this.getPlatform().getFlowConnector(properties).connect("distcache test", sources, sink, (Pipe)splice);
        flow.complete();
        DistCacheTapPlatformTest.validateLength((Flow)flow, (int)5);
        List values = DistCacheTapPlatformTest.getSinkAsList((Flow)flow);
        DistCacheTapPlatformTest.assertTrue((boolean)values.contains(new Tuple(new Object[]{"1\ta\t1\tA"})));
        DistCacheTapPlatformTest.assertTrue((boolean)values.contains(new Tuple(new Object[]{"2\tb\t2\tB"})));
        DistCacheTapPlatformTest.assertTrue((boolean)values.contains(new Tuple(new Object[]{"3\tc\t3\tC"})));
        DistCacheTapPlatformTest.assertTrue((boolean)values.contains(new Tuple(new Object[]{"4\td\t4\tD"})));
        DistCacheTapPlatformTest.assertTrue((boolean)values.contains(new Tuple(new Object[]{"5\te\t5\tE"})));
    }
}

