/*
 * Decompiled with CFR 0.152.
 */
package cascading.platform.hadoop;

import cascading.CascadingException;
import cascading.tuple.Hasher;
import cascading.tuple.StreamComparator;
import cascading.tuple.hadoop.TupleSerialization;
import cascading.tuple.hadoop.io.BufferedInputStream;
import cascading.tuple.hadoop.io.HadoopTupleInputStream;
import cascading.tuple.io.TupleInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Comparator;

public class TestStringComparator
implements Hasher<String>,
StreamComparator<BufferedInputStream>,
Comparator<String>,
Serializable {
    boolean reverse = true;

    public TestStringComparator() {
    }

    public TestStringComparator(boolean reverse) {
        this.reverse = reverse;
    }

    @Override
    public int compare(String o1, String o2) {
        return this.reverse ? o2.compareTo(o1) : o1.compareTo(o2);
    }

    @Override
    public int compare(BufferedInputStream lhsStream, BufferedInputStream rhsStream) {
        HadoopTupleInputStream lhsInput = new HadoopTupleInputStream((InputStream)lhsStream, (TupleInputStream.ElementReader)new TupleSerialization().getElementReader());
        HadoopTupleInputStream rhsInput = new HadoopTupleInputStream((InputStream)rhsStream, (TupleInputStream.ElementReader)new TupleSerialization().getElementReader());
        try {
            String s1 = lhsInput.readString();
            String s2 = rhsInput.readString();
            return this.reverse ? s2.compareTo(s1) : s1.compareTo(s2);
        }
        catch (IOException exception) {
            throw new CascadingException((Throwable)exception);
        }
    }

    public int hashCode(String value) {
        if (value == null) {
            return 0;
        }
        return value.hashCode();
    }
}

