/*
 * Decompiled with CFR 0.152.
 */
package cascading.platform.hadoop;

import cascading.nested.json.hadoop3.JSONTextLine;
import cascading.platform.TestPlatform;
import cascading.platform.hadoop.HadoopConfigDefScheme;
import cascading.platform.hadoop.HadoopFailScheme;
import cascading.platform.hadoop.TestLongComparator;
import cascading.platform.hadoop.TestStringComparator;
import cascading.scheme.Scheme;
import cascading.scheme.hadoop.TextDelimited;
import cascading.scheme.hadoop.TextLine;
import cascading.scheme.util.DelimitedParser;
import cascading.scheme.util.FieldTypeResolver;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tap.hadoop.Hfs;
import cascading.tap.hadoop.PartitionTap;
import cascading.tap.partition.Partition;
import cascading.tuple.Fields;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseHadoopPlatform<Config extends Configuration>
extends TestPlatform {
    private static final Logger LOG = LoggerFactory.getLogger(BaseHadoopPlatform.class);
    public static transient FileSystem fileSys;
    public static transient Configuration configuration;
    public static transient Map<Object, Object> properties;
    protected String logger = System.getProperty("log4j.logger");

    public BaseHadoopPlatform() {
        this.numMappers = 4;
        this.numReducers = 1;
    }

    public boolean isMapReduce() {
        return true;
    }

    public void setNumMappers(int numMapTasks) {
        if (numMapTasks > 0) {
            this.numMappers = numMapTasks;
        }
    }

    public void setNumReducers(int numReduceTasks) {
        if (numReduceTasks > 0) {
            this.numReducers = numReduceTasks;
        }
    }

    public void setNumGatherPartitions(int numGatherPartitions) {
        if (numGatherPartitions > 0) {
            this.numGatherPartitions = numGatherPartitions;
        }
    }

    public Map<Object, Object> getProperties() {
        return new HashMap<Object, Object>(properties);
    }

    public void tearDown() {
    }

    public abstract Config getConfiguration();

    public boolean isHDFSAvailable() {
        try {
            FileSystem fileSystem = FileSystem.get((URI)new URI("hdfs:", null, null), (Configuration)configuration);
            return fileSystem != null;
        }
        catch (IOException exception) {
            LOG.warn("unable to get hdfs filesystem", (Throwable)exception);
        }
        catch (URISyntaxException exception) {
            throw new RuntimeException("internal failure", exception);
        }
        return false;
    }

    public void copyFromLocal(String inputFile) throws IOException {
        if (!new File(inputFile).exists()) {
            throw new FileNotFoundException("data file not found: " + inputFile);
        }
        if (!this.isUseCluster()) {
            return;
        }
        Path path = new Path(this.safeFileName(inputFile));
        if (!fileSys.exists(path)) {
            FileUtil.copy((File)new File(inputFile), (FileSystem)fileSys, (Path)path, (boolean)false, (Configuration)configuration);
        }
    }

    public void copyToLocal(String outputFile) throws IOException {
        FileStatus[] contents;
        if (!this.isUseCluster()) {
            return;
        }
        Path path = new Path(this.safeFileName(outputFile));
        if (!fileSys.exists(path)) {
            throw new FileNotFoundException("data file not found: " + outputFile);
        }
        File file = new File(outputFile);
        if (file.exists()) {
            file.delete();
        }
        if (fileSys.isFile(path)) {
            FileUtil.copy((FileSystem)fileSys, (Path)path, (File)file, (boolean)false, (Configuration)configuration);
            return;
        }
        file.mkdirs();
        for (FileStatus fileStatus : contents = fileSys.listStatus(path)) {
            Path currentPath = fileStatus.getPath();
            if (currentPath.getName().startsWith("_")) continue;
            FileUtil.copy((FileSystem)fileSys, (Path)currentPath, (File)new File(file, currentPath.getName()), (boolean)false, (Configuration)configuration);
        }
    }

    public boolean remoteExists(String outputFile) throws IOException {
        return fileSys.exists(new Path(this.safeFileName(outputFile)));
    }

    public boolean remoteRemove(String outputFile, boolean recursive) throws IOException {
        return fileSys.delete(new Path(this.safeFileName(outputFile)), recursive);
    }

    public Tap getTap(Scheme scheme, String filename, SinkMode mode) {
        return new Hfs(scheme, this.safeFileName(filename), mode);
    }

    public Tap getTextFile(Fields sourceFields, Fields sinkFields, String filename, SinkMode mode) {
        if (sourceFields == null) {
            return new Hfs((Scheme)new TextLine(), this.safeFileName(filename), mode);
        }
        return new Hfs((Scheme)new TextLine(sourceFields, sinkFields), this.safeFileName(filename), mode);
    }

    public Tap getDelimitedFile(Fields fields, boolean hasHeader, String delimiter, String quote, Class[] types, String filename, SinkMode mode) {
        return new Hfs((Scheme)new TextDelimited(fields, hasHeader, delimiter, quote, types), this.safeFileName(filename), mode);
    }

    public Tap getDelimitedFile(Fields fields, boolean skipHeader, boolean writeHeader, String delimiter, String quote, Class[] types, String filename, SinkMode mode) {
        return new Hfs((Scheme)new TextDelimited(fields, skipHeader, writeHeader, delimiter, quote, types), this.safeFileName(filename), mode);
    }

    public Tap getDelimitedFile(String delimiter, String quote, FieldTypeResolver fieldTypeResolver, String filename, SinkMode mode) {
        return new Hfs((Scheme)new TextDelimited(true, new DelimitedParser(delimiter, quote, fieldTypeResolver)), this.safeFileName(filename), mode);
    }

    public Tap getJSONFile(Fields fields, String filename, SinkMode mode) {
        return new Hfs((Scheme)new JSONTextLine(fields), this.safeFileName(filename), mode);
    }

    public Tap getPartitionTap(Tap sink, Partition partition, int openThreshold) {
        return new PartitionTap((Hfs)sink, partition, openThreshold);
    }

    public abstract Tap getDistCacheTap(Hfs var1);

    public Scheme getTestConfigDefScheme() {
        return new HadoopConfigDefScheme(new Fields(new Comparable[]{"line"}), this.isDAG());
    }

    public Scheme getTestFailScheme() {
        return new HadoopFailScheme(new Fields(new Comparable[]{"line"}));
    }

    public Comparator getLongComparator(boolean reverseSort) {
        return new TestLongComparator(reverseSort);
    }

    public Comparator getStringComparator(boolean reverseSort) {
        return new TestStringComparator(reverseSort);
    }

    public String getHiddenTemporaryPath() {
        return "_temporary";
    }

    protected String safeFileName(String filename) {
        return filename.replace(":", "_");
    }

    static {
        properties = new HashMap<Object, Object>();
    }
}

