/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.hadoop.util;

import cascading.flow.FlowProcess;
import cascading.util.CloseableIterator;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;

public class TimedIterator<V>
implements CloseableIterator<V> {
    private final FlowProcess flowProcess;
    private final Enum durationCounter;
    private final Enum countCounter;
    private final int ordinal;
    Iterator<V> iterator;

    public static <V> TimedIterator<V>[] iterators(TimedIterator<V> ... iterators) {
        return iterators;
    }

    public TimedIterator(FlowProcess flowProcess, Enum durationCounter, Enum countCounter) {
        this(flowProcess, durationCounter, countCounter, 0);
    }

    public TimedIterator(FlowProcess flowProcess, Enum durationCounter, Enum countCounter, int ordinal) {
        this.flowProcess = flowProcess;
        this.durationCounter = durationCounter;
        this.countCounter = countCounter;
        this.ordinal = ordinal;
    }

    public void reset(Iterable<V> iterable) {
        this.iterator = iterable == null ? null : iterable.iterator();
    }

    public void reset(Iterator<V> iterator) {
        this.iterator = iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNext() {
        if (this.iterator == null) {
            return false;
        }
        long start = System.currentTimeMillis();
        try {
            boolean bl = this.iterator.hasNext();
            return bl;
        }
        finally {
            this.flowProcess.increment(this.durationCounter, System.currentTimeMillis() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V next() {
        long start = System.currentTimeMillis();
        try {
            this.flowProcess.increment(this.countCounter, 1L);
            V v = this.iterator.next();
            return v;
        }
        finally {
            this.flowProcess.increment(this.durationCounter, System.currentTimeMillis() - start);
        }
    }

    public void remove() {
        this.iterator.remove();
    }

    public void close() throws IOException {
        if (this.iterator instanceof Closeable) {
            ((Closeable)((Object)this.iterator)).close();
        }
    }
}

