/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.hadoop;

import cascading.flow.FlowProcess;
import cascading.tap.Tap;
import cascading.tap.TapException;
import cascading.tap.hadoop.BaseDistCacheTap;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;

public class DistCacheTap
extends BaseDistCacheTap {
    public static final String CASCADING_LOCAL_RESOURCES = "cascading.resources.local.";
    public static final String CASCADING_REMOTE_RESOURCES = "cascading.resources.remote.";

    public DistCacheTap(Tap<Configuration, RecordReader, OutputCollector> original) {
        super(original);
    }

    protected Path[] getLocalCacheFiles(FlowProcess<? extends Configuration> flowProcess) throws IOException {
        String key = CASCADING_REMOTE_RESOURCES + Tap.id((Tap)this);
        String property = flowProcess.getStringProperty(key);
        if (property == null) {
            throw new TapException("unable to find local resources property for: " + key);
        }
        String[] split = property.split(",");
        Path[] paths = new Path[split.length];
        for (int i = 0; i < split.length; ++i) {
            paths[i] = new Path(split[i]);
        }
        return paths;
    }

    protected void addLocalCacheFiles(Configuration conf, URI uri) {
        String key = CASCADING_LOCAL_RESOURCES + Tap.id((Tap)this);
        ArrayList<String> resources = conf.getStringCollection(key);
        if (resources == null) {
            resources = new ArrayList<String>();
        }
        resources.add(uri.toString());
        conf.setStrings(key, resources.toArray(new String[resources.size()]));
    }
}

