/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.tez.util;

import cascading.CascadingException;
import cascading.flow.FlowException;
import cascading.flow.hadoop.util.HadoopUtil;
import cascading.util.Util;
import com.google.protobuf.ByteString;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.mapreduce.hadoop.MRInputHelpers;
import org.apache.tez.mapreduce.hadoop.mapreduce.TaskAttemptContextImpl;
import org.apache.tez.mapreduce.input.MRInput;
import org.apache.tez.mapreduce.lib.MRReader;
import org.apache.tez.mapreduce.output.MROutput;
import org.apache.tez.runtime.api.AbstractLogicalInput;
import org.apache.tez.runtime.api.AbstractLogicalOutput;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.MergedLogicalInput;
import org.apache.tez.runtime.api.ProcessorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TezUtil {
    private static final Logger LOG = LoggerFactory.getLogger(TezUtil.class);

    public static JobConf asJobConf(Configuration configuration) {
        return new JobConf(configuration);
    }

    public static TezConfiguration createTezConf(Map<Object, Object> properties, TezConfiguration defaultJobconf) {
        TezConfiguration jobConf;
        TezConfiguration tezConfiguration = jobConf = defaultJobconf == null ? new TezConfiguration() : new TezConfiguration((Configuration)defaultJobconf);
        if (properties == null) {
            return jobConf;
        }
        HashSet<Object> keys = new HashSet<Object>(properties.keySet());
        if (properties instanceof Properties) {
            keys.addAll(((Properties)properties).stringPropertyNames());
        }
        for (Object e : keys) {
            Object value = properties.get(e);
            if (value == null && properties instanceof Properties && e instanceof String) {
                value = ((Properties)properties).getProperty((String)e);
            }
            if (value == null || value instanceof Class || value instanceof TezConfiguration) continue;
            jobConf.set(e.toString(), value.toString());
        }
        return jobConf;
    }

    public static UserGroupInformation getCurrentUser() {
        try {
            return UserGroupInformation.getCurrentUser();
        }
        catch (IOException exception) {
            throw new CascadingException("unable to get current user", (Throwable)exception);
        }
    }

    public static String getEdgeSourceID(LogicalInput input, Configuration configuration) {
        String id = configuration.get("cascading.node.source");
        if (id == null) {
            throw new IllegalStateException("no source id found: " + input.getClass().getName());
        }
        return id;
    }

    public static String getEdgeSinkID(LogicalOutput output, Configuration configuration) {
        String id = configuration.get("cascading.node.sink");
        if (id == null) {
            throw new IllegalStateException("no sink id found: " + output.getClass().getName());
        }
        return id;
    }

    public static Configuration getInputConfiguration(LogicalInput input) {
        try {
            if (input instanceof MergedLogicalInput) {
                input = (LogicalInput)Util.getFirst((Collection)((MergedLogicalInput)input).getInputs());
            }
            if (input instanceof MRInput) {
                return TezUtils.createConfFromByteString((ByteString)MRInputHelpers.parseMRInputPayload((UserPayload)((MRInput)input).getContext().getUserPayload()).getConfigurationBytes());
            }
            if (input instanceof AbstractLogicalInput) {
                return TezUtils.createConfFromUserPayload((UserPayload)((AbstractLogicalInput)input).getContext().getUserPayload());
            }
        }
        catch (IOException exception) {
            throw new FlowException("unable to unpack payload", (Throwable)exception);
        }
        throw new IllegalStateException("unknown input type: " + input.getClass().getName());
    }

    public static Configuration getOutputConfiguration(LogicalOutput output) {
        try {
            if (output instanceof MROutput) {
                return TezUtils.createConfFromUserPayload((UserPayload)((MROutput)output).getContext().getUserPayload());
            }
            if (output instanceof AbstractLogicalOutput) {
                return TezUtils.createConfFromUserPayload((UserPayload)((AbstractLogicalOutput)output).getContext().getUserPayload());
            }
        }
        catch (IOException exception) {
            throw new FlowException("unable to unpack payload", (Throwable)exception);
        }
        throw new IllegalStateException("unknown input type: " + output.getClass().getName());
    }

    public static void setSourcePathForSplit(MRInput input, MRReader reader, Configuration configuration) {
        Path path = null;
        if (((Boolean)Util.returnInstanceFieldIfExistsSafe((Object)input, (String)"useNewApi")).booleanValue()) {
            org.apache.hadoop.mapreduce.InputSplit newInputSplit = (org.apache.hadoop.mapreduce.InputSplit)reader.getSplit();
            if (newInputSplit instanceof FileSplit) {
                path = ((FileSplit)newInputSplit).getPath();
            }
        } else {
            InputSplit oldInputSplit = (InputSplit)reader.getSplit();
            if (oldInputSplit instanceof org.apache.hadoop.mapred.FileSplit) {
                path = ((org.apache.hadoop.mapred.FileSplit)oldInputSplit).getPath();
            }
        }
        if (path != null) {
            configuration.set("cascading.source.path", path.toString());
        }
    }

    public static Map<Path, Path> addToClassPath(Configuration config, String stagingRoot, String resourceSubPath, Collection<String> classpath, LocalResourceType resourceType, Map<String, LocalResource> localResources, Map<String, String> environment) {
        if (classpath == null) {
            return null;
        }
        HashMap localPaths = new HashMap();
        HashMap remotePaths = new HashMap();
        HadoopUtil.resolvePaths((Configuration)config, classpath, (String)stagingRoot, (String)resourceSubPath, localPaths, remotePaths);
        try {
            LocalFileSystem localFS = HadoopUtil.getLocalFS((Configuration)config);
            for (String fileName : localPaths.keySet()) {
                Path artifact = (Path)localPaths.get(fileName);
                Path remotePath = (Path)remotePaths.get(fileName);
                if (remotePath == null) {
                    remotePath = artifact;
                }
                TezUtil.addResource(localResources, environment, fileName, localFS.getFileStatus(artifact), remotePath, resourceType);
            }
            FileSystem defaultFS = HadoopUtil.getDefaultFS((Configuration)config);
            for (String fileName : remotePaths.keySet()) {
                Path artifact = (Path)remotePaths.get(fileName);
                Path localPath = (Path)localPaths.get(fileName);
                if (localPath != null) continue;
                TezUtil.addResource(localResources, environment, fileName, defaultFS.getFileStatus(artifact), artifact, resourceType);
            }
        }
        catch (IOException exception) {
            throw new FlowException("unable to set remote resource paths", (Throwable)exception);
        }
        return HadoopUtil.getCommonPaths(localPaths, remotePaths);
    }

    protected static void addResource(Map<String, LocalResource> localResources, Map<String, String> environment, String fileName, FileStatus stats, Path fullPath, LocalResourceType type) throws IOException {
        if (localResources.containsKey(fileName)) {
            throw new FlowException("duplicate filename added to classpath resources: " + fileName);
        }
        URL yarnUrlFromPath = ConverterUtils.getYarnUrlFromPath((Path)fullPath);
        long len = stats.getLen();
        long modificationTime = stats.getModificationTime();
        LocalResource resource = LocalResource.newInstance((URL)yarnUrlFromPath, (LocalResourceType)type, (LocalResourceVisibility)LocalResourceVisibility.APPLICATION, (long)len, (long)modificationTime);
        if (type == LocalResourceType.PATTERN) {
            String pattern = "(?:classes/|lib/).*";
            resource.setPattern(pattern);
            if (environment != null) {
                String current = "";
                current = current + ApplicationConstants.Environment.PWD.$$() + File.separator + fileName + File.separator + "*" + "<CPS>";
                current = current + ApplicationConstants.Environment.PWD.$$() + File.separator + fileName + File.separator + "lib" + File.separator + "*" + "<CPS>";
                current = current + ApplicationConstants.Environment.PWD.$$() + File.separator + fileName + File.separator + "classes" + File.separator + "*" + "<CPS>";
                String classPath = environment.get(ApplicationConstants.Environment.CLASSPATH.name());
                if (classPath == null) {
                    classPath = "";
                } else if (!classPath.startsWith("<CPS>")) {
                    classPath = classPath + "<CPS>";
                }
                classPath = classPath + current;
                LOG.info("adding to cluster side classpath: {} ", (Object)classPath);
                environment.put(ApplicationConstants.Environment.CLASSPATH.name(), classPath);
            }
        }
        localResources.put(fileName, resource);
    }

    public static void setMRProperties(ProcessorContext context, Configuration config, boolean isMapperOutput) {
        TaskAttemptID taskAttemptId = TaskAttemptContextImpl.createMockTaskAttemptID((long)context.getApplicationId().getClusterTimestamp(), (int)context.getTaskVertexIndex(), (int)context.getApplicationId().getId(), (int)context.getTaskIndex(), (int)context.getTaskAttemptNumber(), (boolean)isMapperOutput);
        config.set("mapreduce.task.attempt.id", taskAttemptId.toString());
        config.set("mapreduce.task.id", taskAttemptId.getTaskID().toString());
        config.setBoolean("mapreduce.task.ismap", isMapperOutput);
        config.setInt("mapreduce.task.partition", taskAttemptId.getTaskID().getId());
    }
}

