/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.tez.util;

import cascading.CascadingException;
import cascading.tuple.Tuple;
import cascading.tuple.io.TuplePair;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.tez.runtime.library.api.KeyValuesReader;

public class SecondarySortKeyValuesReader
extends KeyValuesReader {
    private KeyValuesReader parent;
    private Comparator<Tuple> groupComparator;
    private Tuple currentKey;
    private Iterable<Object> currentValues;
    private boolean isNewKey = false;
    private TuplePair currentKeyPair;

    public SecondarySortKeyValuesReader(KeyValuesReader parent, Comparator<Tuple> groupComparator) {
        this.parent = parent;
        this.groupComparator = groupComparator;
    }

    public boolean next() throws IOException {
        if (this.parent != null && this.isNewKey) {
            this.isNewKey = false;
            return true;
        }
        boolean advanced = this.advance();
        while (!this.isNewKey && advanced) {
            advanced = this.advance();
        }
        this.isNewKey = false;
        return advanced;
    }

    protected boolean advance() throws IOException {
        if (this.parent == null) {
            return false;
        }
        boolean next = this.parent.next();
        if (!next) {
            this.parent = null;
            return false;
        }
        this.currentKeyPair = (TuplePair)this.parent.getCurrentKey();
        this.isNewKey = this.currentKey == null || this.groupComparator.compare(this.currentKey, this.currentKeyPair.getLhs()) != 0;
        this.currentKey = this.currentKeyPair.getLhs();
        this.currentValues = this.parent.getCurrentValues();
        return true;
    }

    public Object getCurrentKey() throws IOException {
        return this.currentKeyPair;
    }

    public Iterable<Object> getCurrentValues() throws IOException {
        return new Iterable<Object>(){

            @Override
            public Iterator<Object> iterator() {
                final Iterator[] iterator = new Iterator[]{SecondarySortKeyValuesReader.this.currentValues.iterator()};
                return new Iterator<Object>(){

                    @Override
                    public boolean hasNext() {
                        boolean hasNext = iterator[0].hasNext();
                        if (hasNext) {
                            return true;
                        }
                        if (!this.advanceSafe()) {
                            return false;
                        }
                        if (SecondarySortKeyValuesReader.this.isNewKey) {
                            return false;
                        }
                        iterator[0] = SecondarySortKeyValuesReader.this.currentValues.iterator();
                        return this.hasNext();
                    }

                    @Override
                    public Object next() {
                        return iterator[0].next();
                    }

                    @Override
                    public void remove() {
                        iterator[0].remove();
                    }

                    protected boolean advanceSafe() {
                        try {
                            return SecondarySortKeyValuesReader.this.advance();
                        }
                        catch (IOException exception) {
                            throw new CascadingException("unable to advance values iterator", (Throwable)exception);
                        }
                    }
                };
            }
        };
    }
}

