/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.tez.stream.element;

import cascading.cascade.CascadeException;
import cascading.flow.FlowProcess;
import cascading.flow.FlowProcessWrapper;
import cascading.flow.stream.element.SourceStage;
import cascading.flow.tez.Hadoop2TezFlowProcess;
import cascading.flow.tez.util.TezUtil;
import cascading.tap.Tap;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.mapreduce.input.MRInput;
import org.apache.tez.mapreduce.lib.MRReader;
import org.apache.tez.runtime.api.LogicalInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TezSourceStage
extends SourceStage {
    private static final Logger LOG = LoggerFactory.getLogger(TezSourceStage.class);
    private final MRInput logicalInput;
    private MRReader reader;

    public TezSourceStage(FlowProcess flowProcess, Tap source, LogicalInput logicalInput) {
        super(flowProcess, source);
        if (logicalInput == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        this.logicalInput = (MRInput)logicalInput;
    }

    public void prepare() {
        LOG.info("calling {}#start() on: {}", (Object)this.logicalInput.getClass().getSimpleName(), (Object)this.getSource());
        this.logicalInput.start();
        Hadoop2TezFlowProcess tezFlowProcess = (Hadoop2TezFlowProcess)FlowProcessWrapper.undelegate((FlowProcess)this.flowProcess);
        TezConfiguration configuration = tezFlowProcess.getConfiguration();
        try {
            this.reader = (MRReader)this.logicalInput.getReader();
        }
        catch (IOException exception) {
            throw new CascadeException("unable to get reader", (Throwable)exception);
        }
        TezUtil.setSourcePathForSplit(this.logicalInput, this.reader, (Configuration)configuration);
    }

    public void run(Object input) throws Throwable {
        RecordReader oldRecordReader = (RecordReader)this.reader.getRecordReader();
        super.run((Object)oldRecordReader);
    }
}

