/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.tez.stream.element;

import cascading.flow.FlowProcess;
import cascading.flow.FlowProcessWrapper;
import cascading.flow.stream.element.SinkStage;
import cascading.flow.tez.Hadoop2TezFlowProcess;
import cascading.flow.tez.stream.element.OldOutputCollector;
import cascading.tap.Tap;
import java.io.IOException;
import org.apache.tez.mapreduce.output.MROutput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TezSinkStage
extends SinkStage {
    private static final Logger LOG = LoggerFactory.getLogger(TezSinkStage.class);
    private final MROutput logicalOutput;
    private OldOutputCollector collector;

    public TezSinkStage(FlowProcess flowProcess, Tap sink, LogicalOutput logicalOutput) {
        super(flowProcess, sink);
        if (logicalOutput == null) {
            throw new IllegalArgumentException("output must not be null");
        }
        this.logicalOutput = (MROutput)logicalOutput;
    }

    public void prepare() {
        LOG.info("calling {}#start() on: {}", (Object)this.logicalOutput.getClass().getSimpleName(), (Object)this.getSink());
        this.logicalOutput.start();
        this.collector = new OldOutputCollector((LogicalOutput)this.logicalOutput);
        super.prepare();
    }

    public void cleanup() {
        try {
            super.cleanup();
        }
        finally {
            try {
                if (this.logicalOutput.isCommitRequired()) {
                    this.commit(this.logicalOutput);
                }
            }
            catch (Exception exception) {
                LOG.warn("exception on output close", (Throwable)exception);
            }
        }
    }

    protected Object getOutput() {
        return this.collector;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void commit(MROutput output) throws IOException {
        int retries = 3;
        while (true) {
            try {
                while (!((Hadoop2TezFlowProcess)FlowProcessWrapper.undelegate((FlowProcess)this.flowProcess)).getContext().canCommit()) {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            catch (IOException exception) {
                LOG.warn("failure sending canCommit", (Throwable)exception);
                if (--retries == 0) throw exception;
                continue;
            }
            break;
        }
        try {
            output.commit();
            return;
        }
        catch (IOException exception) {
            LOG.warn("failure committing", (Throwable)exception);
            this.discardOutput(output);
            throw exception;
        }
    }

    private void discardOutput(MROutput output) {
        try {
            output.abort();
        }
        catch (IOException exception) {
            LOG.warn("failure cleaning up", (Throwable)exception);
        }
    }
}

