/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.tez.stream.element;

import cascading.CascadingException;
import cascading.flow.FlowProcess;
import cascading.flow.SliceCounters;
import cascading.flow.planner.Scope;
import cascading.flow.stream.duct.Duct;
import cascading.flow.stream.duct.DuctException;
import cascading.flow.stream.element.InputSource;
import cascading.flow.stream.element.SpliceGate;
import cascading.flow.stream.graph.IORole;
import cascading.flow.stream.graph.StreamGraph;
import cascading.flow.tez.stream.element.OldOutputCollector;
import cascading.pipe.Pipe;
import cascading.pipe.Splice;
import cascading.tap.hadoop.util.MeasuredOutputCollector;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.io.KeyTuple;
import cascading.tuple.io.ValueTuple;
import cascading.tuple.util.Resettable1;
import cascading.util.SortedListMultiMap;
import cascading.util.Util;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.library.api.KeyValueReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TezMergeGate
extends SpliceGate<TupleEntry, TupleEntry>
implements InputSource {
    private static final Logger LOG = LoggerFactory.getLogger(TezMergeGate.class);
    protected Collection<LogicalOutput> logicalOutputs;
    protected SortedListMultiMap<Integer, LogicalInput> logicalInputs;
    private MeasuredOutputCollector collector;
    private TupleEntry valueEntry;
    private final Resettable1<Tuple> keyTuple = new KeyTuple();

    public TezMergeGate(FlowProcess flowProcess, Splice splice, IORole role, Collection<LogicalOutput> logicalOutputs) {
        super(flowProcess, splice, role);
        if (logicalOutputs == null || logicalOutputs.isEmpty()) {
            throw new IllegalArgumentException("output must not be null or empty");
        }
        this.logicalOutputs = logicalOutputs;
    }

    public TezMergeGate(FlowProcess flowProcess, Splice splice, IORole role, SortedListMultiMap<Integer, LogicalInput> logicalInputs) {
        super(flowProcess, splice, role);
        if (logicalInputs == null || logicalInputs.getKeys().size() == 0) {
            throw new IllegalArgumentException("inputs must not be null or empty");
        }
        HashSet inputs = new HashSet(logicalInputs.getValues());
        if (inputs.size() != 1) {
            throw new IllegalArgumentException("only supports a single input");
        }
        this.logicalInputs = logicalInputs;
    }

    public void initialize() {
        super.initialize();
        Scope outgoingScope = (Scope)Util.getFirst((Collection)this.outgoingScopes);
        this.valueEntry = new TupleEntry(outgoingScope.getOutValuesFields(), true);
    }

    public void bind(StreamGraph streamGraph) {
        if (this.role != IORole.sink) {
            this.next = this.getNextFor(streamGraph);
        }
    }

    public void prepare() {
        try {
            if (this.logicalInputs != null) {
                for (LogicalInput logicalInput : (List)this.logicalInputs.getValues()) {
                    LOG.info("calling {}#start() on: {} {}, for {} inputs", new Object[]{logicalInput.getClass().getSimpleName(), this.getSplice(), Pipe.id((Pipe)this.getSplice()), ((List)this.logicalInputs.getValues()).size()});
                    logicalInput.start();
                }
            }
            if (this.logicalOutputs != null) {
                for (LogicalOutput logicalOutput : this.logicalOutputs) {
                    LOG.info("calling {}#start() on: {} {}", new Object[]{logicalOutput.getClass().getSimpleName(), this.getSplice(), Pipe.id((Pipe)this.getSplice())});
                    logicalOutput.start();
                }
            }
        }
        catch (Exception exception) {
            throw new CascadingException("unable to start input/output", (Throwable)exception);
        }
        if (this.role != IORole.source) {
            this.collector = new MeasuredOutputCollector(this.flowProcess, (Enum)SliceCounters.Write_Duration, this.createOutputCollector());
        }
        super.prepare();
    }

    public void start(Duct previous) {
        if (this.next != null) {
            super.start(previous);
        }
    }

    public void receive(Duct previous, int ordinal, TupleEntry incomingEntry) {
        try {
            this.keyTuple.reset((Object)incomingEntry.getTuple());
            this.collector.collect(this.keyTuple, (Object)ValueTuple.NULL);
            this.flowProcess.increment((Enum)SliceCounters.Tuples_Written, 1L);
        }
        catch (OutOfMemoryError error) {
            this.handleReThrowableException("out of memory, try increasing task memory allocation", error);
        }
        catch (CascadingException exception) {
            this.handleException(exception, incomingEntry);
        }
        catch (Throwable throwable) {
            this.handleException((Throwable)new DuctException("internal error: " + incomingEntry.getTuple().print(), throwable), incomingEntry);
        }
    }

    public void complete(Duct previous) {
        if (this.next != null) {
            super.complete(previous);
        }
    }

    public void run(Object input) throws Throwable {
        Throwable throwable = this.map();
        if (throwable != null) {
            throw throwable;
        }
    }

    protected Throwable map() throws Exception {
        Throwable localThrowable = null;
        try {
            this.start((Duct)this);
            LogicalInput logicalInput = (LogicalInput)Util.getFirst((Collection)this.logicalInputs.getValues());
            KeyValueReader reader = (KeyValueReader)logicalInput.getReader();
            while (reader.next()) {
                Tuple currentKey = (Tuple)reader.getCurrentKey();
                this.valueEntry.setTuple(currentKey);
                this.next.receive((Duct)this, 0, (Object)this.valueEntry);
            }
            this.complete((Duct)this);
        }
        catch (Throwable throwable) {
            if (!(throwable instanceof OutOfMemoryError)) {
                LOG.error("caught throwable", throwable);
            }
            return throwable;
        }
        return localThrowable;
    }

    protected OutputCollector createOutputCollector() {
        if (this.logicalOutputs.size() == 1) {
            return new OldOutputCollector((LogicalOutput)Util.getFirst(this.logicalOutputs));
        }
        final OutputCollector[] collectors = new OutputCollector[this.logicalOutputs.size()];
        int count = 0;
        for (LogicalOutput logicalOutput : this.logicalOutputs) {
            collectors[count++] = new OldOutputCollector(logicalOutput);
        }
        return new OutputCollector(){

            public void collect(Object key, Object value) throws IOException {
                for (OutputCollector outputCollector : collectors) {
                    outputCollector.collect(key, value);
                }
            }
        };
    }
}

