/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.tez.stream.element;

import cascading.CascadingException;
import cascading.flow.FlowProcess;
import cascading.flow.hadoop.stream.HadoopGroupGate;
import cascading.flow.stream.duct.Duct;
import cascading.flow.stream.element.InputSource;
import cascading.flow.stream.graph.IORole;
import cascading.flow.tez.stream.element.OldOutputCollector;
import cascading.pipe.Pipe;
import cascading.pipe.Splice;
import cascading.tuple.Tuple;
import cascading.util.SortedListMultiMap;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.library.output.OrderedPartitionedKVOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TezGroupGate
extends HadoopGroupGate
implements InputSource {
    private static final Logger LOG = LoggerFactory.getLogger(TezGroupGate.class);
    protected OrderedPartitionedKVOutput logicalOutput;
    protected SortedListMultiMap<Integer, LogicalInput> logicalInputs;

    public TezGroupGate(FlowProcess flowProcess, Splice splice, IORole role, LogicalOutput logicalOutput) {
        super(flowProcess, splice, role);
        if (logicalOutput == null) {
            throw new IllegalArgumentException("output must not be null");
        }
        this.logicalOutput = (OrderedPartitionedKVOutput)logicalOutput;
    }

    public TezGroupGate(FlowProcess flowProcess, Splice splice, IORole role, SortedListMultiMap<Integer, LogicalInput> logicalInputs) {
        super(flowProcess, splice, role);
        if (logicalInputs == null || logicalInputs.getKeys().size() == 0) {
            throw new IllegalArgumentException("inputs must not be null or empty");
        }
        this.logicalInputs = logicalInputs;
    }

    public void initialize() {
        super.initialize();
        if (this.role == IORole.sink) {
            return;
        }
        this.initComparators();
    }

    public void prepare() {
        try {
            if (this.logicalInputs != null) {
                for (LogicalInput logicalInput : (List)this.logicalInputs.getValues()) {
                    LOG.info("calling {}#start() on: {} {}, for {} inputs", new Object[]{logicalInput.getClass().getSimpleName(), this.getSplice(), Pipe.id((Pipe)this.getSplice()), ((List)this.logicalInputs.getValues()).size()});
                    logicalInput.start();
                }
            }
            if (this.logicalOutput != null) {
                LOG.info("calling {}#start() on: {} {}", new Object[]{this.logicalOutput.getClass().getSimpleName(), this.getSplice(), Pipe.id((Pipe)this.getSplice())});
                this.logicalOutput.start();
            }
        }
        catch (Exception exception) {
            throw new CascadingException("unable to start input/output", (Throwable)exception);
        }
        super.prepare();
    }

    public void run(Object input) throws Throwable {
        Throwable throwable = this.reduce();
        if (throwable != null) {
            throw throwable;
        }
    }

    protected abstract Throwable reduce() throws Exception;

    protected void wrapGroupingAndCollect(Duct previous, int ordinal, Tuple valuesTuple, Tuple groupKey) throws IOException {
        this.collector.collect((Object)groupKey, (Object)valuesTuple);
    }

    protected OutputCollector createOutputCollector() {
        return new OldOutputCollector((LogicalOutput)this.logicalOutput);
    }
}

