/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.tez.stream.element;

import cascading.flow.FlowProcess;
import cascading.flow.SliceCounters;
import cascading.flow.hadoop.HadoopGroupByClosure;
import cascading.flow.hadoop.util.TimedIterator;
import cascading.flow.stream.StopDataNotificationException;
import cascading.flow.stream.duct.Duct;
import cascading.flow.stream.graph.IORole;
import cascading.flow.tez.TezGroupByClosure;
import cascading.flow.tez.stream.element.TezGroupGate;
import cascading.flow.tez.util.SecondarySortKeyValuesReader;
import cascading.pipe.GroupBy;
import cascading.pipe.Splice;
import cascading.tuple.Tuple;
import cascading.tuple.io.TuplePair;
import cascading.util.LogUtil;
import cascading.util.SortedListMultiMap;
import cascading.util.Util;
import java.util.Collection;
import java.util.Iterator;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.library.api.KeyValuesReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TezGroupByGate
extends TezGroupGate {
    private static final Logger LOG = LoggerFactory.getLogger(TezGroupByGate.class);
    protected TimedIterator[] timedIterators;

    public TezGroupByGate(FlowProcess flowProcess, GroupBy groupBy, IORole role, LogicalOutput logicalOutput) {
        super(flowProcess, (Splice)groupBy, role, logicalOutput);
    }

    public TezGroupByGate(FlowProcess flowProcess, GroupBy groupBy, IORole role, SortedListMultiMap<Integer, LogicalInput> logicalInputs) {
        super(flowProcess, (Splice)groupBy, role, logicalInputs);
        this.timedIterators = TimedIterator.iterators((TimedIterator[])new TimedIterator[]{new TimedIterator(flowProcess, (Enum)SliceCounters.Read_Duration, (Enum)SliceCounters.Tuples_Read)});
    }

    @Override
    protected Throwable reduce() throws Exception {
        try {
            this.start((Duct)this);
            LogicalInput logicalInput = (LogicalInput)Util.getFirst((Collection)this.logicalInputs.getValues());
            KeyValuesReader reader = (KeyValuesReader)logicalInput.getReader();
            if (this.sortFields != null) {
                reader = new SecondarySortKeyValuesReader(reader, this.groupComparators[0]);
            }
            while (reader.next()) {
                Tuple currentKey = (Tuple)reader.getCurrentKey();
                Iterable currentValues = reader.getCurrentValues();
                this.timedIterators[0].reset(currentValues);
                try {
                    this.accept(currentKey, (Iterator[])this.timedIterators);
                }
                catch (StopDataNotificationException exception) {
                    LogUtil.logWarnOnce((Logger)LOG, (String)"received unsupported stop data notification, ignoring: {}", (Object)exception.getMessage());
                }
            }
            this.complete((Duct)this);
        }
        catch (Throwable throwable) {
            if (!(throwable instanceof OutOfMemoryError)) {
                LOG.error("caught throwable", throwable);
            }
            return throwable;
        }
        return null;
    }

    protected HadoopGroupByClosure createClosure() {
        return new TezGroupByClosure(this.flowProcess, this.keyFields, this.valuesFields);
    }

    protected Tuple unwrapGrouping(Tuple key) {
        return this.sortFields == null ? key : new Tuple(((TuplePair)key).getLhs());
    }
}

