/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.tez.stream.element;

import cascading.CascadingException;
import cascading.flow.FlowProcess;
import cascading.flow.SliceCounters;
import cascading.flow.hadoop.HadoopCoGroupClosure;
import cascading.flow.hadoop.util.TimedIterator;
import cascading.flow.stream.StopDataNotificationException;
import cascading.flow.stream.duct.Duct;
import cascading.flow.stream.duct.DuctException;
import cascading.flow.stream.graph.IORole;
import cascading.flow.tez.TezCoGroupClosure;
import cascading.flow.tez.stream.element.TezGroupGate;
import cascading.pipe.CoGroup;
import cascading.pipe.Splice;
import cascading.tuple.Tuple;
import cascading.tuple.io.TuplePair;
import cascading.util.LogUtil;
import cascading.util.SortedListMultiMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.library.api.KeyValuesReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TezCoGroupGate
extends TezGroupGate {
    private static final Logger LOG = LoggerFactory.getLogger(TezCoGroupGate.class);
    protected TimedIterator<Tuple>[] timedIterators;

    public TezCoGroupGate(FlowProcess flowProcess, CoGroup coGroup, IORole role, LogicalOutput logicalOutput) {
        super(flowProcess, (Splice)coGroup, role, logicalOutput);
    }

    public TezCoGroupGate(FlowProcess flowProcess, CoGroup coGroup, IORole role, SortedListMultiMap<Integer, LogicalInput> logicalInputs) {
        super(flowProcess, (Splice)coGroup, role, logicalInputs);
        this.timedIterators = new TimedIterator[logicalInputs.getKeys().size()];
        for (int i = 0; i < this.timedIterators.length; ++i) {
            this.timedIterators[i] = new TimedIterator(flowProcess, (Enum)SliceCounters.Read_Duration, (Enum)SliceCounters.Tuples_Read, i);
        }
    }

    @Override
    protected Throwable reduce() throws Exception {
        try {
            this.start((Duct)this);
            SortedListMultiMap<Integer, KeyValuesReader> readers = this.getKeyValuesReaders();
            SortedListMultiMap<Tuple, Iterable<Tuple>> iterables = this.getSortedMultiMap(readers.getKeys().size());
            Map.Entry<Tuple, List<Iterable<Tuple>>> current = this.forwardToNext(readers, iterables, null);
            while (current != null) {
                List<Iterable<Tuple>> currentValues = current.getValue();
                for (int i = 0; i < this.timedIterators.length; ++i) {
                    this.timedIterators[i].reset(currentValues.get(i));
                }
                try {
                    this.accept(current.getKey(), (Iterator[])this.timedIterators);
                }
                catch (StopDataNotificationException exception) {
                    LogUtil.logWarnOnce((Logger)LOG, (String)"received unsupported stop data notification, ignoring: {}", (Object)exception.getMessage());
                }
                current = this.forwardToNext(readers, iterables, currentValues);
            }
            this.complete((Duct)this);
        }
        catch (Throwable throwable) {
            if (!(throwable instanceof OutOfMemoryError)) {
                LOG.error("caught throwable", throwable);
            }
            return throwable;
        }
        return null;
    }

    private SortedListMultiMap<Integer, KeyValuesReader> getKeyValuesReaders() throws Exception {
        SortedListMultiMap readers = new SortedListMultiMap();
        for (Map.Entry entry : this.logicalInputs.getEntries()) {
            for (LogicalInput logicalInput : (List)entry.getValue()) {
                readers.put(entry.getKey(), (Object)((KeyValuesReader)logicalInput.getReader()));
            }
        }
        return readers;
    }

    private Map.Entry<Tuple, List<Iterable<Tuple>>> forwardToNext(SortedListMultiMap<Integer, KeyValuesReader> readers, SortedListMultiMap<Tuple, Iterable<Tuple>> iterables, List<Iterable<Tuple>> current) {
        try {
            int size = current == null ? readers.getKeys().size() : current.size();
            for (int ordinal = 0; ordinal < size; ++ordinal) {
                if (current != null && current.get(ordinal) == null) continue;
                for (KeyValuesReader reader : (List)readers.getValues((Object)ordinal)) {
                    if (!reader.next()) continue;
                    Tuple currentKey = (Tuple)reader.getCurrentKey();
                    if (this.splice.isSorted()) {
                        currentKey = ((TuplePair)currentKey).getLhs();
                    }
                    currentKey = this.getDelegatedTuple(currentKey);
                    Iterable currentValues = reader.getCurrentValues();
                    iterables.set((Object)currentKey, ordinal, (Object)currentValues);
                }
            }
        }
        catch (OutOfMemoryError error) {
            this.handleReThrowableException("out of memory, try increasing task memory allocation", error);
        }
        catch (CascadingException exception) {
            this.handleException(exception, null);
        }
        catch (Throwable throwable) {
            this.handleException((Throwable)new DuctException("internal error", throwable), null);
        }
        return iterables.pollFirstEntry();
    }

    private SortedListMultiMap<Tuple, Iterable<Tuple>> getSortedMultiMap(final int length) {
        return new SortedListMultiMap<Tuple, Iterable<Tuple>>(this.getKeyComparator(), length){
            Iterable<Tuple>[] array;
            {
                super(x0, x1);
                this.array = new Iterable[length];
            }

            protected List createCollection() {
                List collection = super.createCollection();
                Collections.addAll(collection, this.array);
                return collection;
            }
        };
    }

    protected HadoopCoGroupClosure createClosure() {
        return new TezCoGroupClosure(this.flowProcess, this.splice.getNumSelfJoins(), this.keyFields, this.valuesFields);
    }

    protected Tuple unwrapGrouping(Tuple key) {
        return key;
    }
}

