/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.tez.planner;

import cascading.flow.FlowConnector;
import cascading.flow.FlowDef;
import cascading.flow.FlowElement;
import cascading.flow.FlowStep;
import cascading.flow.hadoop.util.HadoopUtil;
import cascading.flow.planner.BaseFlowStepFactory;
import cascading.flow.planner.FlowPlanner;
import cascading.flow.planner.PlannerInfo;
import cascading.flow.planner.PlatformInfo;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.iso.transformer.ElementFactory;
import cascading.flow.planner.process.FlowNodeGraph;
import cascading.flow.planner.process.FlowStepFactory;
import cascading.flow.planner.rule.RuleRegistry;
import cascading.flow.planner.rule.transformer.BoundaryElementFactory;
import cascading.flow.tez.Hadoop2TezFlow;
import cascading.flow.tez.Hadoop2TezFlowStep;
import cascading.flow.tez.util.TezUtil;
import cascading.pipe.Boundary;
import cascading.property.AppProps;
import cascading.property.PropertyUtil;
import cascading.tap.Tap;
import cascading.tap.hadoop.DistCacheTap;
import cascading.tap.hadoop.Hfs;
import cascading.tap.hadoop.util.TempHfs;
import cascading.util.Util;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.TezConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hadoop2TezPlanner
extends FlowPlanner<Hadoop2TezFlow, TezConfiguration> {
    private static final Logger LOG = LoggerFactory.getLogger(Hadoop2TezPlanner.class);
    public static final String PLATFORM_NAME = "hadoop2-tez";
    private TezConfiguration defaultConfiguration;
    private Class intermediateSchemeClass;

    public static void copyConfiguration(Map<Object, Object> properties, Configuration configuration) {
        for (Map.Entry entry : configuration) {
            properties.put(entry.getKey(), entry.getValue());
        }
    }

    public static TezConfiguration createConfiguration(Map<Object, Object> properties) {
        TezConfiguration conf = new TezConfiguration();
        Hadoop2TezPlanner.copyProperties((Configuration)conf, properties);
        return conf;
    }

    public static void copyProperties(Configuration jobConf, Map<Object, Object> properties) {
        if (properties instanceof Properties) {
            Properties props = (Properties)properties;
            Set<String> keys = props.stringPropertyNames();
            for (String key : keys) {
                jobConf.set(key, props.getProperty(key));
            }
        } else {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                if (entry.getValue() == null) continue;
                jobConf.set(entry.getKey().toString(), entry.getValue().toString());
            }
        }
    }

    public PlannerInfo getPlannerInfo(String registryName) {
        return new PlannerInfo(((Object)((Object)this)).getClass().getSimpleName(), PLATFORM_NAME, registryName);
    }

    public TezConfiguration getDefaultConfig() {
        return this.defaultConfiguration;
    }

    public PlatformInfo getPlatformInfo() {
        return HadoopUtil.getPlatformInfo(DAG.class, null, (String)"Tez");
    }

    public void initialize(FlowConnector flowConnector, Map<Object, Object> properties) {
        super.initialize(flowConnector, properties);
        this.defaultConfiguration = TezUtil.createTezConf(properties, Hadoop2TezPlanner.createConfiguration(properties));
        this.intermediateSchemeClass = flowConnector.getIntermediateSchemeClass(properties);
        String applicationJarPath = AppProps.getApplicationJarPath(properties);
        if (applicationJarPath == null) {
            Class type = AppProps.getApplicationJarClass(properties);
            if (type == null) {
                type = HadoopUtil.findMainClass(Hadoop2TezPlanner.class);
            }
            if (type != null) {
                applicationJarPath = Util.findContainingJar((Class)type);
            }
            AppProps.setApplicationJarPath(properties, (String)applicationJarPath);
        }
        if (applicationJarPath != null) {
            LOG.info("using application jar: {}", (Object)applicationJarPath);
        } else {
            LOG.info("using application jar not provided, see cascading.property.AppProps for more information");
        }
    }

    public void configRuleRegistryDefaults(RuleRegistry ruleRegistry) {
        super.configRuleRegistryDefaults(ruleRegistry);
        ruleRegistry.addDefaultElementFactory("cascading.registry.tap.intermediate", (ElementFactory)new FlowPlanner.TempTapElementFactory((FlowPlanner)this));
        ruleRegistry.addDefaultElementFactory("cascading.registry.boundary_pipe", (ElementFactory)new IntermediateBoundaryElementFactory());
        if (PropertyUtil.getBooleanProperty((Map)this.getDefaultProperties(), (String)"cascading.flowconnector.accumulated_tap.decorator.enable", (boolean)true)) {
            ruleRegistry.addDefaultElementFactory("cascading.registry.tap.accumulated", (ElementFactory)new FlowPlanner.TempTapElementFactory((FlowPlanner)this, DistCacheTap.class.getName()));
        }
    }

    protected Hadoop2TezFlow createFlow(FlowDef flowDef) {
        return new Hadoop2TezFlow(this.getPlatformInfo(), this.getDefaultProperties(), this.getDefaultConfig(), flowDef);
    }

    public FlowStepFactory<TezConfiguration> getFlowStepFactory() {
        return new BaseFlowStepFactory<TezConfiguration>(this.getFlowNodeFactory()){

            public FlowStep<TezConfiguration> createFlowStep(ElementGraph stepElementGraph, FlowNodeGraph flowNodeGraph) {
                return new Hadoop2TezFlowStep(stepElementGraph, flowNodeGraph);
            }
        };
    }

    public URI getDefaultURIScheme(Tap tap) {
        return ((Hfs)tap).getDefaultFileSystemURIScheme((Configuration)this.defaultConfiguration);
    }

    public URI getURIScheme(Tap tap) {
        return ((Hfs)tap).getURIScheme((Configuration)this.defaultConfiguration);
    }

    protected Tap makeTempTap(String prefix, String name) {
        return new TempHfs((Configuration)TezUtil.asJobConf((Configuration)this.defaultConfiguration), Util.makePath((String)prefix, (String)name), this.intermediateSchemeClass, prefix == null);
    }

    public class IntermediateBoundaryElementFactory
    extends BoundaryElementFactory {
        public FlowElement create(ElementGraph graph, FlowElement flowElement) {
            return new Boundary();
        }
    }
}

