/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.tez;

import cascading.CascadingException;
import cascading.flow.FlowProcess;
import cascading.flow.FlowSession;
import cascading.flow.hadoop.MapRed;
import cascading.flow.hadoop.util.HadoopUtil;
import cascading.tap.Tap;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.TupleEntryIterator;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.mapreduce.processor.MRTaskReporter;
import org.apache.tez.runtime.api.ProcessorContext;
import org.apache.tez.runtime.api.Writer;

public class Hadoop2TezFlowProcess
extends FlowProcess<TezConfiguration>
implements MapRed {
    final TezConfiguration configuration;
    private ProcessorContext context;
    private Writer writer;

    public Hadoop2TezFlowProcess() {
        this.configuration = new TezConfiguration();
    }

    public Hadoop2TezFlowProcess(TezConfiguration configuration) {
        this.configuration = configuration;
    }

    public Hadoop2TezFlowProcess(FlowSession flowSession, ProcessorContext context, TezConfiguration configuration) {
        super(flowSession);
        this.context = context;
        this.configuration = configuration;
    }

    public Hadoop2TezFlowProcess(Hadoop2TezFlowProcess flowProcess, TezConfiguration configuration) {
        super((FlowProcess)flowProcess);
        this.context = flowProcess.context;
        this.configuration = configuration;
    }

    public ProcessorContext getContext() {
        return this.context;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public FlowProcess copyWith(TezConfiguration configuration) {
        return new Hadoop2TezFlowProcess(this, configuration);
    }

    public TezConfiguration getConfiguration() {
        return this.configuration;
    }

    public TezConfiguration getConfig() {
        return this.configuration;
    }

    public TezConfiguration getConfigCopy() {
        return new TezConfiguration((Configuration)this.configuration);
    }

    public int getCurrentSliceNum() {
        return this.getConfiguration().getInt("mapred.task.partition", 0);
    }

    public int getNumProcessSlices() {
        return 0;
    }

    public Reporter getReporter() {
        if (this.context == null) {
            return Reporter.NULL;
        }
        return new MRTaskReporter(this.context);
    }

    public Object getProperty(String key) {
        return this.configuration.get(key);
    }

    public Collection<String> getPropertyKeys() {
        HashSet keys = new HashSet();
        for (Map.Entry entry : this.configuration) {
            keys.add(entry.getKey());
        }
        return Collections.unmodifiableSet(keys);
    }

    public Object newInstance(String className) {
        if (className == null || className.isEmpty()) {
            return null;
        }
        try {
            Class<?> type = Hadoop2TezFlowProcess.class.getClassLoader().loadClass(className.toString());
            return ReflectionUtils.newInstance(type, (Configuration)this.configuration);
        }
        catch (ClassNotFoundException exception) {
            throw new CascadingException("unable to load class: " + className.toString(), (Throwable)exception);
        }
    }

    public void keepAlive() {
    }

    public void increment(Enum counter, long amount) {
        if (this.context != null) {
            this.context.getCounters().findCounter(counter).increment(amount);
        }
    }

    public void increment(String group, String counter, long amount) {
        if (this.context != null) {
            this.context.getCounters().findCounter(group, counter).increment(amount);
        }
    }

    public long getCounterValue(Enum counter) {
        if (this.context == null) {
            return 0L;
        }
        return this.context.getCounters().findCounter(counter).getValue();
    }

    public long getCounterValue(String group, String counter) {
        if (this.context == null) {
            return 0L;
        }
        return this.context.getCounters().findCounter(group, counter).getValue();
    }

    public void setStatus(String status) {
    }

    public boolean isCounterStatusInitialized() {
        if (this.context == null) {
            return false;
        }
        return this.context.getCounters() != null;
    }

    public TupleEntryIterator openTapForRead(Tap tap) throws IOException {
        return tap.openForRead((FlowProcess)this);
    }

    public TupleEntryCollector openTapForWrite(Tap tap) throws IOException {
        return tap.openForWrite((FlowProcess)this, null);
    }

    public TupleEntryCollector openTrapForWrite(Tap trap) throws IOException {
        TezConfiguration jobConf = new TezConfiguration((Configuration)this.getConfiguration());
        int stepNum = jobConf.getInt("cascading.flow.step.num", 0);
        int nodeNum = jobConf.getInt("cascading.flow.node.num", 0);
        String partname = String.format("-%05d-%05d-", stepNum, nodeNum);
        jobConf.set("cascading.tapcollector.partname", "%s%spart" + partname + "%05d");
        return trap.openForWrite((FlowProcess)new Hadoop2TezFlowProcess(this, jobConf), null);
    }

    public TupleEntryCollector openSystemIntermediateForWrite() throws IOException {
        return null;
    }

    public <C> C copyConfig(C config) {
        return (C)HadoopUtil.copyJobConf(config);
    }

    public <C> Map<String, String> diffConfigIntoMap(C defaultConfig, C updatedConfig) {
        return HadoopUtil.getConfig((Configuration)((Configuration)defaultConfig), (Configuration)((Configuration)updatedConfig));
    }

    public TezConfiguration mergeMapIntoConfig(TezConfiguration defaultConfig, Map<String, String> map) {
        return (TezConfiguration)HadoopUtil.mergeConf((Configuration)new TezConfiguration((Configuration)defaultConfig), map, (boolean)true);
    }
}

