/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.tez;

import cascading.flow.BaseFlow;
import cascading.flow.Flow;
import cascading.flow.FlowDef;
import cascading.flow.FlowException;
import cascading.flow.FlowProcess;
import cascading.flow.FlowStep;
import cascading.flow.hadoop.util.HadoopUtil;
import cascading.flow.planner.BaseFlowStep;
import cascading.flow.planner.PlatformInfo;
import cascading.flow.tez.Hadoop2TezFlowProcess;
import cascading.flow.tez.Hadoop2TezFlowStep;
import cascading.property.PropertyUtil;
import cascading.tap.hadoop.io.HttpFileSystem;
import cascading.util.ShutdownUtil;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.dag.api.TezConfiguration;
import riffle.process.ProcessConfiguration;

public class Hadoop2TezFlow
extends BaseFlow<TezConfiguration> {
    private static Thread hdfsShutdown = null;
    private static ShutdownUtil.Hook shutdownHook;
    private transient TezConfiguration flowConf;
    private boolean preserveTemporaryFiles = false;
    private String flowStagingPath;

    protected Hadoop2TezFlow() {
    }

    static boolean getPreserveTemporaryFiles(Map<Object, Object> properties) {
        return Boolean.parseBoolean((String)PropertyUtil.getProperty(properties, (String)"cascading.flow.preservetemporaryfiles", (Object)"false"));
    }

    static int getMaxConcurrentSteps(TezConfiguration jobConf) {
        return jobConf.getInt("cascading.flow.maxconcurrentsteps", 0);
    }

    public Hadoop2TezFlow(PlatformInfo platformInfo, Map<Object, Object> properties, TezConfiguration flowConf, FlowDef flowDef) {
        super(platformInfo, properties, (Object)flowConf, flowDef);
        this.initFromProperties(properties);
    }

    protected void initFromProperties(Map<Object, Object> properties) {
        super.initFromProperties(properties);
        this.preserveTemporaryFiles = Hadoop2TezFlow.getPreserveTemporaryFiles(properties);
    }

    protected void initConfig(Map<Object, Object> properties, TezConfiguration parentConfig) {
        if (properties != null) {
            parentConfig = (TezConfiguration)this.createConfig(properties, parentConfig);
        }
        if (parentConfig == null) {
            return;
        }
        this.flowConf = new TezConfiguration((Configuration)parentConfig);
        this.flowConf.set("fs.http.impl", HttpFileSystem.class.getName());
        this.flowConf.set("fs.https.impl", HttpFileSystem.class.getName());
        UserGroupInformation.setConfiguration((Configuration)this.flowConf);
        this.flowStagingPath = this.createStagingRoot();
    }

    public String getFlowStagingPath() {
        if (this.flowStagingPath == null) {
            this.flowStagingPath = this.createStagingRoot();
        }
        return this.flowStagingPath;
    }

    private String createStagingRoot() {
        return ".staging/" + this.getID();
    }

    protected void setConfigProperty(TezConfiguration config, Object key, Object value) {
        if (value instanceof Class || value instanceof Configuration || value == null) {
            return;
        }
        config.set(key.toString(), value.toString());
    }

    protected TezConfiguration newConfig(TezConfiguration defaultConfig) {
        return defaultConfig == null ? new TezConfiguration() : new TezConfiguration((Configuration)defaultConfig);
    }

    @ProcessConfiguration
    public TezConfiguration getConfig() {
        if (this.flowConf == null) {
            this.initConfig(null, new TezConfiguration());
        }
        return this.flowConf;
    }

    public TezConfiguration getConfigCopy() {
        return new TezConfiguration((Configuration)this.getConfig());
    }

    public Map<Object, Object> getConfigAsProperties() {
        return HadoopUtil.createProperties((Configuration)this.getConfig());
    }

    public String getProperty(String key) {
        return this.getConfig().get(key);
    }

    public FlowProcess<TezConfiguration> getFlowProcess() {
        return new Hadoop2TezFlowProcess(this.getFlowSession(), null, this.getConfig());
    }

    public boolean isPreserveTemporaryFiles() {
        return this.preserveTemporaryFiles;
    }

    protected void internalStart() {
        try {
            this.copyArtifactsToRemote();
            this.deleteSinksIfReplace();
            this.deleteTrapsIfReplace();
            this.deleteCheckpointsIfReplace();
        }
        catch (IOException exception) {
            throw new FlowException("unable to delete sinks", (Throwable)exception);
        }
        Hadoop2TezFlow.registerHadoopShutdownHook((Flow)this);
    }

    private void copyArtifactsToRemote() {
        for (FlowStep flowStep : this.getFlowSteps()) {
            ((Hadoop2TezFlowStep)flowStep).syncArtifacts();
        }
    }

    public boolean stepsAreLocal() {
        return HadoopUtil.isLocal((Configuration)this.getConfig());
    }

    private void cleanTemporaryFiles(boolean stop) {
        if (stop) {
            return;
        }
        for (FlowStep step : this.getFlowSteps()) {
            ((BaseFlowStep)step).clean();
        }
    }

    private static synchronized void registerHadoopShutdownHook(Flow flow) {
        if (!flow.isStopJobsOnExit()) {
            return;
        }
        if (shutdownHook != null) {
            return;
        }
        Hadoop2TezFlow.getHdfsShutdownHook();
        shutdownHook = new ShutdownUtil.Hook(){

            public ShutdownUtil.Hook.Priority priority() {
                return ShutdownUtil.Hook.Priority.LAST;
            }

            public void execute() {
                Hadoop2TezFlow.callHdfsShutdownHook();
            }
        };
        ShutdownUtil.addHook((ShutdownUtil.Hook)shutdownHook);
    }

    private static synchronized void callHdfsShutdownHook() {
        if (hdfsShutdown != null) {
            hdfsShutdown.start();
        }
    }

    private static synchronized void getHdfsShutdownHook() {
        if (hdfsShutdown == null) {
            hdfsShutdown = HadoopUtil.getHDFSShutdownHook();
        }
    }

    protected void internalClean(boolean stop) {
        if (!this.isPreserveTemporaryFiles()) {
            this.cleanTemporaryFiles(stop);
        }
    }

    protected void internalShutdown() {
    }

    protected int getMaxNumParallelSteps() {
        return this.stepsAreLocal() ? 1 : Hadoop2TezFlow.getMaxConcurrentSteps(this.getConfig());
    }

    protected long getTotalSliceCPUMilliSeconds() {
        long counterValue = this.flowStats.getCounterValue((Enum)TaskCounter.CPU_MILLISECONDS);
        if (counterValue == 0L) {
            return -1L;
        }
        return counterValue;
    }
}

