/*
 * Decompiled with CFR 0.152.
 */
package cascading.stats.tez;

import cascading.PlatformTestCase;
import cascading.cascade.Cascade;
import cascading.cascade.CascadeConnector;
import cascading.flow.Flow;
import cascading.flow.SliceCounters;
import cascading.operation.Filter;
import cascading.operation.Function;
import cascading.operation.regex.RegexParser;
import cascading.operation.state.Counter;
import cascading.pipe.Each;
import cascading.pipe.GroupBy;
import cascading.pipe.Pipe;
import cascading.stats.CascadeStats;
import cascading.stats.FlowNodeStats;
import cascading.stats.FlowSliceStats;
import cascading.stats.FlowStats;
import cascading.stats.tez.TezNodeStats;
import cascading.stats.tez.TezSliceStats;
import cascading.stats.tez.TezStepStats;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import data.InputData;
import java.util.Collection;
import java.util.List;
import org.junit.Test;

public class TezStatsPlatformTest
extends PlatformTestCase {
    public TezStatsPlatformTest() {
        super(true, 1, 4);
    }

    @Test
    public void testStatsCounters() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(InputData.inputFileApache);
        Pipe pipe = new Pipe("first");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new RegexParser(new Fields(new Comparable[]{"ip"}), "^[^ ]*"), new Fields(new Comparable[]{"ip"}));
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"ip"}));
        pipe = new Each(pipe, (Filter)new Counter((Enum)TestEnum.FIRST));
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"ip"}));
        pipe = new Each(pipe, (Filter)new Counter((Enum)TestEnum.FIRST));
        pipe = new Each(pipe, (Filter)new Counter((Enum)TestEnum.SECOND));
        Tap sink1 = this.getPlatform().getTextFile(this.getOutputPath("flowstats1"), SinkMode.REPLACE);
        Tap sink2 = this.getPlatform().getTextFile(this.getOutputPath("flowstats2"), SinkMode.REPLACE);
        Flow flow1 = this.getPlatform().getFlowConnector().connect("stats1 test", source, sink1, pipe);
        Flow flow2 = this.getPlatform().getFlowConnector().connect("stats2 test", source, sink2, pipe);
        Cascade cascade = new CascadeConnector(this.getProperties()).connect(new Flow[]{flow1, flow2});
        cascade.complete();
        CascadeStats cascadeStats = cascade.getCascadeStats();
        TezStatsPlatformTest.assertNotNull((Object)cascadeStats.getID());
        TezStatsPlatformTest.assertEquals((int)1, (int)cascadeStats.getCounterGroupsMatching("cascading\\.stats\\..*").size());
        TezStatsPlatformTest.assertEquals((int)2, (int)cascadeStats.getCountersFor(TestEnum.class.getName()).size());
        TezStatsPlatformTest.assertEquals((int)2, (int)cascadeStats.getCountersFor(TestEnum.class).size());
        TezStatsPlatformTest.assertEquals((long)40L, (long)cascadeStats.getCounterValue((Enum)TestEnum.FIRST));
        TezStatsPlatformTest.assertEquals((long)20L, (long)cascadeStats.getCounterValue((Enum)TestEnum.SECOND));
        TezStatsPlatformTest.assertEquals((long)0L, (long)cascadeStats.getCounterValue((Enum)TestEnum.THIRD));
        TezStatsPlatformTest.assertEquals((long)0L, (long)cascadeStats.getCounterValue("FOO", "BAR"));
        FlowStats flowStats1 = flow1.getFlowStats();
        TezStatsPlatformTest.assertNotNull((Object)flowStats1.getID());
        TezStatsPlatformTest.assertEquals((long)20L, (long)flowStats1.getCounterValue((Enum)TestEnum.FIRST));
        TezStatsPlatformTest.assertEquals((long)10L, (long)flowStats1.getCounterValue((Enum)TestEnum.SECOND));
        TezStatsPlatformTest.assertEquals((long)0L, (long)flowStats1.getCounterValue((Enum)TestEnum.THIRD));
        TezStatsPlatformTest.assertEquals((long)0L, (long)flowStats1.getCounterValue("FOO", "BAR"));
        FlowStats flowStats2 = flow2.getFlowStats();
        TezStatsPlatformTest.assertNotNull((Object)flowStats2.getID());
        TezStatsPlatformTest.assertEquals((long)20L, (long)flowStats2.getCounterValue((Enum)TestEnum.FIRST));
        TezStatsPlatformTest.assertEquals((long)10L, (long)flowStats2.getCounterValue((Enum)TestEnum.SECOND));
        cascadeStats.captureDetail();
        TezStatsPlatformTest.assertEquals((int)1, (int)flowStats1.getStepsCount());
        TezStatsPlatformTest.assertEquals((int)1, (int)flowStats2.getStepsCount());
        TezStepStats stats1 = (TezStepStats)flowStats1.getFlowStepStats().get(0);
        TezStatsPlatformTest.assertNotNull((Object)stats1.getID());
        if (this.getPlatform().isUseCluster()) {
            TezStatsPlatformTest.assertTrue((stats1.getCounterValue((Enum)SliceCounters.Process_Duration) != 0L ? 1 : 0) != 0);
            List flowNodeStats = stats1.getFlowNodeStats();
            TezStatsPlatformTest.assertTrue((((FlowNodeStats)flowNodeStats.get(0)).getCounterValue((Enum)SliceCounters.Process_Duration) != 0L ? 1 : 0) != 0);
            TezStatsPlatformTest.assertEquals((int)3, (int)flowNodeStats.size());
            FlowNodeStats node1 = (FlowNodeStats)flowNodeStats.get(0);
            FlowNodeStats node2 = (FlowNodeStats)flowNodeStats.get(1);
            FlowNodeStats node3 = (FlowNodeStats)flowNodeStats.get(2);
            TezStatsPlatformTest.assertEquals((int)1, (int)node1.getChildren().size());
            TezStatsPlatformTest.assertEquals((int)4, (int)node2.getChildren().size());
            TezStatsPlatformTest.assertEquals((int)4, (int)node3.getChildren().size());
            TezStatsPlatformTest.assertTrue((boolean)((TezNodeStats)node1).isAllChildrenFinished());
            TezStatsPlatformTest.assertTrue((boolean)((TezNodeStats)node2).isAllChildrenFinished());
            TezStatsPlatformTest.assertTrue((boolean)((TezNodeStats)node3).isAllChildrenFinished());
            boolean foundCounter = false;
            Collection children = node2.getChildren();
            for (FlowSliceStats flowSliceStats : children) {
                TezStatsPlatformTest.assertNotSame((Object)-1, (Object)flowSliceStats.getProcessStartTime());
                TezStatsPlatformTest.assertNotSame((Object)-1, (Object)flowSliceStats.getProcessSubmitTime());
                TezStatsPlatformTest.assertNotSame((Object)-1, (Object)flowSliceStats.getProcessRunTime());
                TezStatsPlatformTest.assertNotSame((Object)-1, (Object)flowSliceStats.getProcessFinishTime());
                TezStatsPlatformTest.assertTrue((flowSliceStats.getProcessStartTime() <= flowSliceStats.getProcessSubmitTime() ? 1 : 0) != 0);
                TezStatsPlatformTest.assertTrue((flowSliceStats.getProcessSubmitTime() <= flowSliceStats.getProcessRunTime() ? 1 : 0) != 0);
                TezStatsPlatformTest.assertTrue((flowSliceStats.getProcessRunTime() < flowSliceStats.getProcessFinishTime() ? 1 : 0) != 0);
                TezSliceStats sliceStats = (TezSliceStats)flowSliceStats;
                if (!sliceStats.getCounters().containsKey(TestEnum.FIRST.getDeclaringClass().getName())) continue;
                foundCounter = true;
                TezStatsPlatformTest.assertTrue((sliceStats.getCounterValue((Enum)TestEnum.FIRST) > 0L ? 1 : 0) != 0);
            }
            TezStatsPlatformTest.assertTrue((String)"did not find counter in any slice", (boolean)foundCounter);
        }
        TezStepStats stats2 = (TezStepStats)flowStats2.getFlowStepStats().get(0);
        TezStatsPlatformTest.assertNotNull((Object)stats2.getID());
        if (this.getPlatform().isUseCluster()) {
            List flowNodeStats = stats2.getFlowNodeStats();
            TezStatsPlatformTest.assertEquals((int)3, (int)flowNodeStats.size());
            FlowNodeStats node1 = (FlowNodeStats)flowNodeStats.get(0);
            FlowNodeStats node2 = (FlowNodeStats)flowNodeStats.get(1);
            FlowNodeStats node3 = (FlowNodeStats)flowNodeStats.get(2);
            TezStatsPlatformTest.assertEquals((int)1, (int)node1.getChildren().size());
            TezStatsPlatformTest.assertEquals((int)4, (int)node2.getChildren().size());
            TezStatsPlatformTest.assertEquals((int)4, (int)node3.getChildren().size());
            TezStatsPlatformTest.assertTrue((boolean)((TezNodeStats)node1).isAllChildrenFinished());
            TezStatsPlatformTest.assertTrue((boolean)((TezNodeStats)node2).isAllChildrenFinished());
            TezStatsPlatformTest.assertTrue((boolean)((TezNodeStats)node3).isAllChildrenFinished());
        }
    }

    static enum TestEnum {
        FIRST,
        SECOND,
        THIRD;

    }
}

