/*
 * Decompiled with CFR 0.152.
 */
package cascading.platform.tez;

import cascading.CascadingException;
import cascading.flow.FlowConnector;
import cascading.flow.FlowProcess;
import cascading.flow.FlowProps;
import cascading.flow.FlowSession;
import cascading.flow.tez.Hadoop2TezFlowConnector;
import cascading.flow.tez.Hadoop2TezFlowProcess;
import cascading.flow.tez.planner.Hadoop2TezPlanner;
import cascading.platform.hadoop.BaseHadoopPlatform;
import cascading.tap.Tap;
import cascading.tap.hadoop.DistCacheTap;
import cascading.tap.hadoop.Hfs;
import cascading.util.Util;
import java.io.File;
import java.io.IOException;
import java.security.Permission;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryServer;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.history.logging.ats.ATSHistoryLoggingService;
import org.apache.tez.test.MiniTezCluster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hadoop2TezPlatform
extends BaseHadoopPlatform<TezConfiguration> {
    private static final Logger LOG = LoggerFactory.getLogger(Hadoop2TezPlatform.class);
    private static transient MiniDFSCluster miniDFSCluster;
    private static transient MiniTezCluster miniTezCluster;
    private static transient SecurityManager securityManager;
    private transient ApplicationHistoryServer yarnHistoryServer;

    public Hadoop2TezPlatform() {
        this.numGatherPartitions = 1;
    }

    public String getName() {
        return "hadoop2-tez";
    }

    public FlowConnector getFlowConnector(Map<Object, Object> properties) {
        return new Hadoop2TezFlowConnector(properties);
    }

    public void setNumGatherPartitionTasks(Map<Object, Object> properties, int numGatherPartitions) {
        properties.put("cascading.flow.runtime.gather.partitions.num", Integer.toString(numGatherPartitions));
    }

    public Integer getNumGatherPartitionTasks(Map<Object, Object> properties) {
        if (properties.get("cascading.flow.runtime.gather.partitions.num") == null) {
            return null;
        }
        return Integer.parseInt(properties.get("cascading.flow.runtime.gather.partitions.num").toString());
    }

    public TezConfiguration getConfiguration() {
        return new TezConfiguration(configuration);
    }

    public Tap getDistCacheTap(Hfs parent) {
        return new DistCacheTap((Tap)parent);
    }

    public FlowProcess getFlowProcess() {
        return new Hadoop2TezFlowProcess(FlowSession.NULL, null, this.getConfiguration());
    }

    public boolean isMapReduce() {
        return false;
    }

    public boolean isDAG() {
        return true;
    }

    public synchronized void setUp() throws IOException {
        if (configuration != null) {
            return;
        }
        if (!this.isUseCluster()) {
            LOG.info("not using cluster");
            configuration = new Configuration();
            configuration.setInt("cascading.flow.runtime.gather.partitions.num", this.getNumGatherPartitions());
            configuration.set("tez.local.mode", "true");
            configuration.set("fs.defaultFS", "file:///");
            configuration.set("tez.runtime.optimize.local.fetch", "true");
            configuration.setInt("tez.am.inline.task.execution.max-tasks", 3);
            configuration.set("tez.ignore.lib.uris", "true");
            configuration.setInt("yarn.nodemanager.delete.debug-delay-sec", -1);
            configuration.set("tez.generate.debug.artifacts", "true");
            configuration.set("tez.am.mode.session", "true");
            if (!Util.isEmpty((String)System.getProperty("hadoop.tmp.dir"))) {
                configuration.set("hadoop.tmp.dir", System.getProperty("hadoop.tmp.dir"));
            } else {
                configuration.set("hadoop.tmp.dir", "build/test/tmp");
            }
            fileSys = FileSystem.get((Configuration)configuration);
        } else {
            LOG.info("using cluster");
            if (Util.isEmpty((String)System.getProperty("hadoop.log.dir"))) {
                System.setProperty("hadoop.log.dir", "build/test/log");
            }
            if (Util.isEmpty((String)System.getProperty("hadoop.tmp.dir"))) {
                System.setProperty("hadoop.tmp.dir", "build/test/tmp");
            }
            new File(System.getProperty("hadoop.log.dir")).mkdirs();
            new File(System.getProperty("hadoop.tmp.dir")).mkdirs();
            Configuration defaultConf = new Configuration();
            defaultConf.setInt("cascading.flow.runtime.gather.partitions.num", this.getNumGatherPartitions());
            defaultConf.setInt("yarn.nodemanager.delete.debug-delay-sec", -1);
            defaultConf.setInt("yarn.resourcemanager.am.max-attempts", 1);
            defaultConf.setBoolean("tez.am.node-blacklisting.enabled", false);
            defaultConf.set("hdfs.minidfs.basedir", System.getProperty("hadoop.tmp.dir"));
            miniDFSCluster = new MiniDFSCluster.Builder(defaultConf).numDataNodes(4).format(true).racks(null).build();
            fileSys = miniDFSCluster.getFileSystem();
            Configuration tezConf = new Configuration(defaultConf);
            tezConf.set("fs.defaultFS", fileSys.getUri().toString());
            tezConf.set("yarn.app.mapreduce.am.staging-dir", "/apps_staging_dir");
            miniTezCluster = new MiniTezCluster(((Object)((Object)this)).getClass().getName(), 4, 1, 1);
            miniTezCluster.init(tezConf);
            miniTezCluster.start();
            configuration = miniTezCluster.getConfig();
            if (this.setTimelineStore(configuration)) {
                configuration.set("tez.history.logging.service.class", ATSHistoryLoggingService.class.getName());
                configuration.setBoolean("yarn.timeline-service.enabled", true);
                configuration.set("yarn.timeline-service.address", "localhost:10200");
                configuration.set("yarn.timeline-service.webapp.address", "localhost:8188");
                configuration.set("yarn.timeline-service.webapp.https.address", "localhost:8190");
                this.yarnHistoryServer = new ApplicationHistoryServer();
                this.yarnHistoryServer.init(configuration);
                this.yarnHistoryServer.start();
            }
        }
        configuration.setInt("tez.am.max.app.attempts", 1);
        configuration.setInt("tez.am.task.max.failed.attempts", 1);
        configuration.setInt("tez.am.maxtaskfailures.per.node", 1);
        Map globalProperties = Hadoop2TezPlatform.getGlobalProperties();
        if (this.logger != null) {
            globalProperties.put("log4j.logger", this.logger);
        }
        FlowProps.setJobPollingInterval((Map)globalProperties, (long)10L);
        Hadoop2TezPlanner.copyProperties((Configuration)configuration, (Map)globalProperties);
        Hadoop2TezPlanner.copyConfiguration((Map)properties, (Configuration)configuration);
        ExitUtil.disableSystemExit();
    }

    protected boolean setTimelineStore(Configuration configuration) {
        try {
            Class target = Util.loadClass((String)"org.apache.hadoop.yarn.server.timeline.TimelineStore");
            Class type = Util.loadClass((String)"org.apache.hadoop.yarn.server.timeline.MemoryTimelineStore");
            configuration.setClass("yarn.timeline-service.store-class", type, target);
            try {
                Util.loadClass((String)"org.apache.hadoop.yarn.api.records.timeline.TimelineDomain");
            }
            catch (CascadingException exception) {
                configuration.setBoolean("tez.allow.disabled.timeline-domains", true);
            }
            return true;
        }
        catch (CascadingException exception) {
            try {
                Class target = Util.loadClass((String)"org.apache.hadoop.yarn.server.applicationhistoryservice.timeline.TimelineStore");
                Class type = Util.loadClass((String)"org.apache.hadoop.yarn.server.applicationhistoryservice.timeline.MemoryTimelineStore");
                configuration.setClass("yarn.timeline-service.store-class", type, target);
                configuration.setBoolean("tez.allow.disabled.timeline-domains", true);
                return true;
            }
            catch (CascadingException ignore) {
                return false;
            }
        }
    }

    private static void forbidSystemExitCall() {
        if (securityManager != null) {
            return;
        }
        securityManager = new SecurityManager(){

            @Override
            public void checkPermission(Permission permission) {
                StackTraceElement[] stackTrace;
                if (!"exitVM".equals(permission.getName())) {
                    return;
                }
                for (StackTraceElement stackTraceElement : stackTrace = Thread.currentThread().getStackTrace()) {
                    LOG.warn("exit vm trace: {}", (Object)stackTraceElement);
                }
                throw new ExitTrappedException();
            }
        };
        System.setSecurityManager(securityManager);
    }

    private static void enableSystemExitCall() {
        securityManager = null;
        System.setSecurityManager(null);
    }

    private static class ExitTrappedException
    extends SecurityException {
        private ExitTrappedException() {
        }
    }
}

