/*
 * Decompiled with CFR 0.152.
 */
package cascading.stats.tez.util;

import cascading.CascadingException;
import cascading.stats.tez.util.TaskStatus;
import cascading.stats.tez.util.TimelineClient;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.client.FrameworkClient;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGClientTimelineImpl;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.api.client.StatusGetOpts;
import org.apache.tez.dag.api.client.VertexStatus;
import org.apache.tez.dag.history.logging.EntityTypes;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TezTimelineClient
extends DAGClientTimelineImpl
implements TimelineClient {
    private static final Logger LOG = LoggerFactory.getLogger(TezTimelineClient.class);
    private static final String FILTER_BY_FIELDS = "primaryfilters,otherinfo";
    private final String dagId;
    private final FrameworkClient frameworkClient;
    private final DAGClient dagClient;

    public TezTimelineClient(ApplicationId appId, String dagId, TezConfiguration conf, FrameworkClient frameworkClient, DAGClient dagClient) throws TezException {
        super(appId, dagId, conf, frameworkClient, 5000);
        this.dagId = dagId;
        this.frameworkClient = frameworkClient;
        this.dagClient = dagClient;
    }

    public DAGClient getDAGClient() {
        return this.dagClient;
    }

    public FrameworkClient getFrameworkClient() {
        return this.frameworkClient;
    }

    public DAGStatus getDAGStatus(@Nullable Set<StatusGetOpts> statusOptions) throws IOException, TezException {
        return this.dagClient.getDAGStatus(statusOptions);
    }

    public VertexStatus getVertexStatus(String vertexName, Set<StatusGetOpts> statusOptions) throws IOException, TezException {
        return this.dagClient.getVertexStatus(vertexName, statusOptions);
    }

    @Override
    public String getVertexID(String vertexName) throws IOException, TezException {
        String format = "%s/%s?primaryFilter=%s:%s&secondaryFilter=vertexName:%s&fields=%s";
        String url = String.format(format, this.baseUri, "TEZ_VERTEX_ID", "TEZ_DAG_ID", this.dagId, vertexName, FILTER_BY_FIELDS);
        JSONObject jsonRoot = this.getJsonRootEntity(url);
        JSONArray entitiesNode = jsonRoot.optJSONArray("entities");
        if (entitiesNode == null || entitiesNode.length() != 1) {
            throw new CascadingException("failed to get vertex status from timeline server");
        }
        try {
            return this.getJsonObject(entitiesNode, 0).getString("entity");
        }
        catch (JSONException exception) {
            throw new CascadingException("unable to get vertex node", (Throwable)exception);
        }
    }

    @Override
    public Iterator<TaskStatus> getVertexChildren(String vertexID, int limit, String startTaskID) throws IOException, TezException {
        JSONObject jsonRoot;
        JSONArray entitiesNode;
        if (vertexID == null) {
            throw new IllegalArgumentException("vertexID is required");
        }
        String format = "%s/%s?primaryFilter=%s:%s&fields=%s&limit=%s";
        String url = String.format(format, this.baseUri, EntityTypes.TEZ_TASK_ID, "TEZ_VERTEX_ID", vertexID, FILTER_BY_FIELDS, limit);
        if (startTaskID != null) {
            url = String.format("%s&fromId=%s", url, startTaskID);
        }
        if ((entitiesNode = (jsonRoot = this.getJsonRootEntity(url)).optJSONArray("entities")) == null) {
            throw new CascadingException("failed to get vertex task statuses from timeline server");
        }
        LOG.debug("vertex: {}, retrieved {} tasks", (Object)vertexID, (Object)entitiesNode.length());
        return new Iterator<TaskStatus>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return entitiesNode.length() != this.index;
            }

            @Override
            public TaskStatus next() {
                return TezTimelineClient.this.parseTaskStatus(TezTimelineClient.this.getJsonObject(entitiesNode, this.index++));
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public TaskStatus getVertexChild(String taskID) throws TezException {
        String format = "%s/%s/%s?fields=%s";
        String url = String.format(format, this.baseUri, EntityTypes.TEZ_TASK_ID, taskID, FILTER_BY_FIELDS);
        JSONObject jsonRoot = this.getJsonRootEntity(url);
        if (jsonRoot == null) {
            throw new CascadingException("failed to get vertex task status from timeline server, for id: " + taskID);
        }
        return this.parseTaskStatus(jsonRoot);
    }

    private TaskStatus parseTaskStatus(JSONObject jsonRoot) {
        try {
            String taskID = jsonRoot.optString("entity");
            JSONObject otherInfoNode = jsonRoot.getJSONObject("otherinfo");
            String status = otherInfoNode.optString("status");
            long scheduledTime = otherInfoNode.optLong("scheduledTime", -1L);
            long startTime = otherInfoNode.optLong("startTime", -1L);
            long endTime = otherInfoNode.optLong("endTime", -1L);
            String successfulAttemptID = otherInfoNode.optString("successfulAttemptId");
            String diagnostics = otherInfoNode.optString("diagnostics");
            if (status.equals("")) {
                return new TaskStatus(taskID);
            }
            JSONObject countersNode = otherInfoNode.optJSONObject("counters");
            Map<String, Map<String, Long>> counters = this.parseDagCounters(countersNode);
            return new TaskStatus(taskID, status, scheduledTime, startTime, endTime, successfulAttemptID, counters, diagnostics);
        }
        catch (JSONException exception) {
            throw new CascadingException((Throwable)exception);
        }
    }

    private Map<String, Map<String, Long>> parseDagCounters(JSONObject countersNode) throws JSONException {
        if (countersNode == null) {
            return null;
        }
        JSONArray counterGroupNodes = countersNode.optJSONArray("counterGroups");
        if (counterGroupNodes == null) {
            return null;
        }
        HashMap<String, Map<String, Long>> counters = new HashMap<String, Map<String, Long>>();
        int numCounterGroups = counterGroupNodes.length();
        for (int i = 0; i < numCounterGroups; ++i) {
            this.parseCounterGroup(counters, counterGroupNodes.optJSONObject(i));
        }
        return counters;
    }

    private void parseCounterGroup(Map<String, Map<String, Long>> counters, JSONObject counterGroupNode) throws JSONException {
        if (counterGroupNode == null) {
            return;
        }
        String groupName = counterGroupNode.optString("counterGroupName");
        JSONArray counterNodes = counterGroupNode.optJSONArray("counters");
        int numCounters = counterNodes.length();
        HashMap<String, Long> values = new HashMap<String, Long>();
        counters.put(groupName, values);
        for (int i = 0; i < numCounters; ++i) {
            JSONObject counterNode = counterNodes.getJSONObject(i);
            String counterName = counterNode.getString("counterName");
            long counterValue = counterNode.getLong("counterValue");
            values.put(counterName, counterValue);
        }
    }

    protected JSONObject getRemoveJsonObject(JSONArray entitiesNode, int index, boolean doRemove) {
        try {
            JSONObject jsonObject = entitiesNode.getJSONObject(index);
            if (doRemove) {
                entitiesNode.remove((Object)jsonObject);
            }
            return jsonObject;
        }
        catch (JSONException exception) {
            throw new CascadingException((Throwable)exception);
        }
    }

    protected JSONObject getJsonObject(JSONArray entitiesNode, int index) {
        try {
            return entitiesNode.getJSONObject(index);
        }
        catch (JSONException exception) {
            throw new CascadingException((Throwable)exception);
        }
    }
}

