/*
 * Decompiled with CFR 0.152.
 */
package cascading.stats.tez;

import cascading.stats.CascadingStats;
import cascading.stats.CounterCache;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.common.counters.CounterGroup;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;

public abstract class TezCounterCache<JobStatus>
extends CounterCache<Configuration, JobStatus, TezCounters> {
    protected TezCounterCache(CascadingStats stats, Configuration configuration) {
        super(stats, (Object)configuration);
    }

    protected boolean areCountersAvailable(JobStatus runningJob) {
        return true;
    }

    protected Collection<String> getGroupNames(TezCounters counterGroups) {
        Iterable iterable = counterGroups.getGroupNames();
        if (iterable == null) {
            return Collections.emptySet();
        }
        HashSet<String> groupNames = new HashSet<String>();
        for (String groupName : iterable) {
            groupNames.add(groupName);
        }
        return groupNames;
    }

    protected Set<String> getCountersFor(TezCounters counterGroups, String group) {
        HashSet<String> results = new HashSet<String>();
        for (TezCounter counter : (CounterGroup)counterGroups.getGroup(group)) {
            results.add(counter.getName());
        }
        return results;
    }

    protected long getCounterValue(TezCounters counterGroups, Enum counter) {
        TezCounter tezCounter = counterGroups.findCounter(counter);
        if (tezCounter == null) {
            return 0L;
        }
        return tezCounter.getValue();
    }

    protected long getCounterValue(TezCounters counterGroups, String groupName, String counterName) {
        CounterGroup counterGroup = (CounterGroup)counterGroups.getGroup(groupName);
        if (counterGroup == null) {
            return 0L;
        }
        TezCounter counterValue = counterGroup.findCounter(counterName);
        if (counterValue == null) {
            return 0L;
        }
        return counterValue.getValue();
    }

    protected int getIntProperty(String property, int defaultValue) {
        return ((Configuration)this.configuration).getInt(property, defaultValue);
    }
}

