/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.parquet;

import cascading.flow.FlowProcess;
import cascading.scheme.Scheme;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.tap.Tap;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.parquet.Preconditions;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.mapred.Container;
import org.apache.parquet.hadoop.thrift.ParquetThriftInputFormat;
import org.apache.parquet.hadoop.thrift.ThriftReadSupport;

public abstract class ParquetValueScheme<T>
extends Scheme<JobConf, RecordReader, OutputCollector, Object[], Object[]> {
    private static final long serialVersionUID = 157560846420730043L;
    protected final Config<T> config;

    public ParquetValueScheme() {
        this(new Config());
    }

    public ParquetValueScheme(FilterPredicate filterPredicate) {
        this(new Config().withFilterPredicate(filterPredicate));
    }

    public ParquetValueScheme(Config<T> config) {
        this.config = config;
    }

    @Deprecated
    private void setProjectionPushdown(JobConf jobConf) {
        if (((Config)this.config).deprecatedProjectionString != null) {
            ThriftReadSupport.setProjectionPushdown((JobConf)jobConf, (String)((Config)this.config).deprecatedProjectionString);
        }
    }

    private void setStrictProjectionPushdown(JobConf jobConf) {
        if (((Config)this.config).strictProjectionString != null) {
            ThriftReadSupport.setStrictFieldProjectionFilter((Configuration)jobConf, (String)((Config)this.config).strictProjectionString);
        }
    }

    private void setPredicatePushdown(JobConf jobConf) {
        if (((Config)this.config).filterPredicate != null) {
            ParquetInputFormat.setFilterPredicate((Configuration)jobConf, (FilterPredicate)((Config)this.config).filterPredicate);
        }
    }

    public void sourceConfInit(FlowProcess<? extends JobConf> jobConfFlowProcess, Tap<JobConf, RecordReader, OutputCollector> jobConfRecordReaderOutputCollectorTap, JobConf jobConf) {
        this.setPredicatePushdown(jobConf);
        this.setProjectionPushdown(jobConf);
        this.setStrictProjectionPushdown(jobConf);
        this.setRecordClass(jobConf);
    }

    private void setRecordClass(JobConf jobConf) {
        if (((Config)this.config).klass != null) {
            ParquetThriftInputFormat.setThriftClass((JobConf)jobConf, (Class)((Config)this.config).klass);
        }
    }

    public boolean source(FlowProcess<? extends JobConf> fp, SourceCall<Object[], RecordReader> sc) throws IOException {
        Container value = (Container)((RecordReader)sc.getInput()).createValue();
        boolean hasNext = ((RecordReader)sc.getInput()).next(null, (Object)value);
        if (!hasNext) {
            return false;
        }
        if (value == null) {
            return true;
        }
        sc.getIncomingEntry().setTuple(new Tuple(new Object[]{value.get()}));
        return true;
    }

    public void sink(FlowProcess<? extends JobConf> fp, SinkCall<Object[], OutputCollector> sc) throws IOException {
        TupleEntry tuple = sc.getOutgoingEntry();
        if (tuple.size() != 1) {
            throw new RuntimeException("ParquetValueScheme expects tuples with an arity of exactly 1, but found " + tuple.getFields());
        }
        Object value = tuple.getObject(0);
        OutputCollector output = (OutputCollector)sc.getOutput();
        output.collect(null, value);
    }

    public static final class Config<T>
    implements Serializable {
        private final FilterPredicate filterPredicate;
        private final String deprecatedProjectionString;
        private final String strictProjectionString;
        private final Class<T> klass;

        private Config(Class<T> klass, FilterPredicate filterPredicate, String deprecatedProjectionString, String strictProjectionString) {
            this.filterPredicate = filterPredicate;
            this.deprecatedProjectionString = deprecatedProjectionString;
            this.strictProjectionString = strictProjectionString;
            this.klass = klass;
        }

        public Config() {
            this.filterPredicate = null;
            this.deprecatedProjectionString = null;
            this.strictProjectionString = null;
            this.klass = null;
        }

        public FilterPredicate getFilterPredicate() {
            return this.filterPredicate;
        }

        @Deprecated
        public String getProjectionString() {
            return this.deprecatedProjectionString;
        }

        public String getStrictProjectionString() {
            return this.strictProjectionString;
        }

        public Class<T> getKlass() {
            return this.klass;
        }

        public Config<T> withFilterPredicate(FilterPredicate f) {
            return new Config<T>(this.klass, (FilterPredicate)Preconditions.checkNotNull((Object)f, (String)"filterPredicate"), this.deprecatedProjectionString, this.strictProjectionString);
        }

        @Deprecated
        public Config<T> withProjectionString(String p) {
            return new Config<T>(this.klass, this.filterPredicate, (String)Preconditions.checkNotNull((Object)p, (String)"projectionString"), this.strictProjectionString);
        }

        public Config<T> withStrictProjectionString(String p) {
            return new Config<T>(this.klass, this.filterPredicate, this.deprecatedProjectionString, (String)Preconditions.checkNotNull((Object)p, (String)"projectionString"));
        }

        public Config<T> withRecordClass(Class<T> klass) {
            return new Config<T>((Class)Preconditions.checkNotNull(klass, (String)"recordClass"), this.filterPredicate, this.deprecatedProjectionString, this.strictProjectionString);
        }
    }
}

