/*
 * Decompiled with CFR 0.152.
 */
package cascading.stats.hadoop;

import cascading.stats.CascadingStats;
import cascading.stats.FlowSliceStats;
import cascading.stats.ProvidesCounters;
import cascading.util.Util;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.TaskCompletionEvent;
import org.apache.hadoop.mapreduce.TaskReport;

public class HadoopSliceStats
extends FlowSliceStats<Kind>
implements ProvidesCounters {
    private String id;
    private CascadingStats.Status parentStatus;
    private Kind kind;
    private TaskReport taskReport;
    private Map<String, Map<String, Long>> counters;
    private long lastFetch = -1L;
    private Map<Integer, FlowSliceStats.FlowSliceAttempt> attempts = new HashMap<Integer, FlowSliceStats.FlowSliceAttempt>();

    HadoopSliceStats(String id, CascadingStats.Status parentStatus, Kind kind, TaskReport taskReport, long lastFetch) {
        this.id = id;
        this.parentStatus = parentStatus;
        this.kind = kind;
        this.taskReport = taskReport;
        this.lastFetch = lastFetch;
    }

    public void update(CascadingStats.Status parentStatus, Kind kind, TaskReport taskReport, long lastFetch) {
        this.parentStatus = parentStatus;
        this.kind = kind;
        this.taskReport = taskReport;
        this.lastFetch = lastFetch;
        this.counters = null;
    }

    public String getID() {
        return this.id;
    }

    public Kind getKind() {
        return this.kind;
    }

    public String getProcessSliceID() {
        return this.taskReport.getTaskID().toString();
    }

    public int getTaskIDNum() {
        return this.taskReport.getTaskID().getId();
    }

    public String getProcessNodeID() {
        return null;
    }

    public String getProcessStepID() {
        return this.taskReport.getTaskID().getJobID().toString();
    }

    protected TaskReport getTaskReport() {
        return this.taskReport;
    }

    public float getProgress() {
        return this.taskReport.getProgress();
    }

    public String getProcessStatus() {
        return this.taskReport.getState();
    }

    public float getProcessProgress() {
        return this.taskReport.getProgress();
    }

    public long getProcessStartTime() {
        return this.taskReport.getStartTime();
    }

    public long getProcessFinishTime() {
        return this.taskReport.getFinishTime();
    }

    public CascadingStats.Status getParentStatus() {
        return this.parentStatus;
    }

    public CascadingStats.Status getStatus() {
        CascadingStats.Status status = null;
        switch (this.taskReport.getCurrentStatus()) {
            case PENDING: {
                status = CascadingStats.Status.PENDING;
                break;
            }
            case RUNNING: {
                status = CascadingStats.Status.RUNNING;
                break;
            }
            case COMPLETE: {
                status = CascadingStats.Status.SUCCESSFUL;
                break;
            }
            case KILLED: {
                status = CascadingStats.Status.STOPPED;
                break;
            }
            case FAILED: {
                status = CascadingStats.Status.FAILED;
            }
        }
        return status;
    }

    public String[] getDiagnostics() {
        return this.taskReport.getDiagnostics();
    }

    public Map<String, Map<String, Long>> getCounters() {
        if (this.counters == null) {
            this.setCounters(this.taskReport);
        }
        return this.counters;
    }

    public Map<Integer, FlowSliceStats.FlowSliceAttempt> getAttempts() {
        return this.attempts;
    }

    private void setCounters(TaskReport taskReport) {
        this.counters = new HashMap<String, Map<String, Long>>();
        Counters hadoopCounters = taskReport.getTaskCounters();
        for (CounterGroup group : hadoopCounters) {
            HashMap<String, Long> values = new HashMap<String, Long>();
            this.counters.put(group.getName(), values);
            for (Counter counter : group) {
                values.put(counter.getName(), counter.getValue());
            }
        }
    }

    public void setLastFetch(long lastFetch) {
        this.lastFetch = lastFetch;
    }

    public long getLastSuccessfulCounterFetchTime() {
        return this.lastFetch;
    }

    public Collection<String> getCounterGroups() {
        return this.getCounters().keySet();
    }

    public Collection<String> getCountersFor(String group) {
        return this.getCounters().get(group).keySet();
    }

    public Collection<String> getCountersFor(Class<? extends Enum> group) {
        return this.getCountersFor(group.getDeclaringClass().getName());
    }

    public long getCounterValue(Enum counter) {
        return this.getCounterValue(counter.getDeclaringClass().getName(), counter.name());
    }

    public long getCounterValue(String group, String name) {
        if (this.getCounters() == null || this.getCounters().get(group) == null) {
            return 0L;
        }
        Long value = this.getCounters().get(group).get(name);
        if (value == null) {
            return 0L;
        }
        return value;
    }

    public void addAttempt(TaskCompletionEvent event) {
        this.attempts.put(event.getEventId(), new HadoopAttempt(event));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HadoopSliceStats");
        sb.append("{id='").append(this.id).append('\'');
        sb.append(", kind=").append((Object)this.kind);
        sb.append('}');
        return sb.toString();
    }

    public static enum Kind {
        SETUP,
        MAPPER,
        REDUCER,
        CLEANUP;

    }

    public static class HadoopAttempt
    extends FlowSliceStats.FlowSliceAttempt {
        private final TaskCompletionEvent event;

        public HadoopAttempt(TaskCompletionEvent event) {
            this.event = event;
        }

        public String getProcessAttemptID() {
            return this.event.getTaskAttemptId().toString();
        }

        public int getEventId() {
            return this.event.getEventId();
        }

        public int getProcessDuration() {
            return this.event.getTaskRunTime();
        }

        public String getProcessStatus() {
            return this.event.getStatus().toString();
        }

        public String getStatusURL() {
            return this.event.getTaskTrackerHttp();
        }

        public CascadingStats.Status getStatus() {
            CascadingStats.Status status = null;
            switch (this.event.getStatus()) {
                case FAILED: {
                    status = CascadingStats.Status.FAILED;
                    break;
                }
                case KILLED: {
                    status = CascadingStats.Status.STOPPED;
                    break;
                }
                case SUCCEEDED: {
                    status = CascadingStats.Status.SUCCESSFUL;
                    break;
                }
                case OBSOLETE: {
                    status = CascadingStats.Status.SKIPPED;
                    break;
                }
                case TIPFAILED: {
                    status = CascadingStats.Status.FAILED;
                }
            }
            return status;
        }

        public String getProcessHostname() {
            return Util.parseHostname((String)this.event.getTaskTrackerHttp());
        }
    }
}

