/*
 * Decompiled with CFR 0.152.
 */
package cascading.stats.hadoop;

import cascading.flow.FlowNode;
import cascading.management.state.ClientState;
import cascading.stats.BaseCachedNodeStats;
import cascading.stats.CascadingStats;
import cascading.stats.FlowNodeStats;
import cascading.stats.FlowSliceStats;
import cascading.stats.hadoop.HadoopNodeCounterCache;
import cascading.stats.hadoop.HadoopSliceStats;
import cascading.stats.hadoop.HadoopStepStats;
import cascading.util.Util;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.TaskCompletionEvent;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskReport;
import org.apache.hadoop.mapreduce.TaskType;

public class HadoopNodeStats
extends BaseCachedNodeStats<Configuration, FlowNodeStats, Map<String, Map<String, Long>>> {
    private Map<TaskID, String> sliceIDCache = new HashMap<TaskID, String>(4999);
    private HadoopStepStats parentStepStats;
    private HadoopSliceStats.Kind kind;

    protected HadoopNodeStats(HadoopStepStats parentStepStats, Configuration configuration, HadoopSliceStats.Kind kind, FlowNode flowNode, ClientState clientState) {
        super(flowNode, clientState);
        this.parentStepStats = parentStepStats;
        this.kind = kind;
        this.counterCache = new HadoopNodeCounterCache((FlowNodeStats)this, configuration);
    }

    public String getKind() {
        if (this.kind == null) {
            return null;
        }
        return this.kind.name();
    }

    private CascadingStats.Status getParentStatus() {
        return this.parentStepStats.getStatus();
    }

    private RunningJob getJobStatusClient() {
        return (RunningJob)this.parentStepStats.getJobStatusClient();
    }

    private TaskReport[] retrieveTaskReports(HadoopSliceStats.Kind kind) throws IOException, InterruptedException {
        Job job = HadoopStepStats.getJob(this.getJobStatusClient());
        if (job == null) {
            return new TaskReport[0];
        }
        switch (kind) {
            case MAPPER: {
                return job.getTaskReports(TaskType.MAP);
            }
            case REDUCER: {
                return job.getTaskReports(TaskType.REDUCE);
            }
            case SETUP: {
                return job.getTaskReports(TaskType.JOB_SETUP);
            }
            case CLEANUP: {
                return job.getTaskReports(TaskType.JOB_CLEANUP);
            }
        }
        return new TaskReport[0];
    }

    protected boolean captureChildDetailInternal() {
        if (this.allChildrenFinished) {
            return true;
        }
        Job job = HadoopStepStats.getJob(this.getJobStatusClient());
        if (job == null) {
            return false;
        }
        try {
            TaskReport[] taskReports = this.retrieveTaskReports(this.kind);
            if (taskReports.length == 0) {
                return false;
            }
            this.addTaskStats(taskReports, false);
            return true;
        }
        catch (IOException exception) {
            this.logWarn("unable to retrieve slice stats via task reports", new Object[]{exception});
        }
        catch (InterruptedException exception) {
            this.logWarn("retrieving task reports timed out, consider increasing timeout delay in CounterCache via: '{}', message: {}", new Object[]{"cascading.counter.timeout.seconds", exception.getMessage()});
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTaskStats(TaskReport[] taskReports, boolean skipLast) {
        this.logInfo("retrieved task reports: {}", new Object[]{taskReports.length});
        long lastFetch = System.currentTimeMillis();
        boolean fetchedAreFinished = true;
        Map map = this.sliceStatsMap;
        synchronized (map) {
            int added = 0;
            int updated = 0;
            for (int i = 0; i < taskReports.length - (skipLast ? 1 : 0); ++i) {
                TaskReport taskReport = taskReports[i];
                if (taskReport == null) {
                    this.logWarn("found empty task report", new Object[0]);
                    continue;
                }
                String id = this.getSliceIDFor((TaskID)taskReport.getTaskID());
                HadoopSliceStats sliceStats = (HadoopSliceStats)((Object)this.sliceStatsMap.get(id));
                if (sliceStats != null) {
                    sliceStats.update(this.getParentStatus(), this.kind, taskReport, lastFetch);
                    ++updated;
                } else {
                    sliceStats = new HadoopSliceStats(id, this.getParentStatus(), this.kind, taskReport, lastFetch);
                    this.sliceStatsMap.put(id, sliceStats);
                    ++added;
                }
                if (sliceStats.getStatus().isFinished()) continue;
                fetchedAreFinished = false;
            }
            int total = this.sliceStatsMap.size();
            String duration = Util.formatDurationFromMillis((long)(System.currentTimeMillis() - lastFetch));
            this.logInfo("added {}, updated: {} slices, with duration: {}, total fetched: {}", new Object[]{added, updated, duration, total});
        }
        this.allChildrenFinished = taskReports.length != 0 && fetchedAreFinished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAttempt(TaskCompletionEvent event) {
        FlowSliceStats stats;
        String sliceID = this.sliceIDCache.get(event.getTaskAttemptId().getTaskID());
        if (sliceID == null) {
            return;
        }
        Map map = this.sliceStatsMap;
        synchronized (map) {
            stats = (FlowSliceStats)this.sliceStatsMap.get(sliceID);
        }
        if (stats == null) {
            return;
        }
        ((HadoopSliceStats)stats).addAttempt(event);
    }

    private String getSliceIDFor(TaskID taskID) {
        String id = this.sliceIDCache.get(taskID);
        if (id == null) {
            id = Util.createUniqueID();
            this.sliceIDCache.put(taskID, id);
        }
        return id;
    }
}

