/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.hadoop2;

import cascading.flow.hadoop.planner.HadoopPlanner;
import cascading.flow.hadoop.util.HadoopUtil;
import cascading.flow.planner.PlannerInfo;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hadoop2MR1Planner
extends HadoopPlanner {
    private static final Logger LOG = LoggerFactory.getLogger(Hadoop2MR1Planner.class);
    public static final String PLATFORM_NAME = "hadoop2-mr1";

    public static void copyConfiguration(Map<Object, Object> properties, Configuration configuration) {
        for (Map.Entry entry : configuration) {
            properties.put(entry.getKey(), entry.getValue());
        }
    }

    public static void copyProperties(Configuration configuration, Map<Object, Object> properties) {
        if (properties instanceof Properties) {
            Properties props = (Properties)properties;
            Set<String> keys = props.stringPropertyNames();
            for (String key : keys) {
                configuration.set(key, props.getProperty(key));
            }
        } else {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                if (entry.getValue() == null) continue;
                configuration.set(entry.getKey().toString(), entry.getValue().toString());
            }
        }
    }

    @Override
    public PlannerInfo getPlannerInfo(String registryName) {
        return new PlannerInfo(((Object)((Object)this)).getClass().getSimpleName(), PLATFORM_NAME, registryName);
    }

    @Override
    protected void checkPlatform(Configuration conf) {
        if (!HadoopUtil.isYARN((Configuration)conf)) {
            LOG.warn("running Hadoop 1.x based flows on YARN may cause problems, please use the 'cascading-hadoop' dependencies");
        }
    }
}

