/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.hadoop.stream.graph;

import cascading.flow.FlowElement;
import cascading.flow.FlowNode;
import cascading.flow.FlowProcess;
import cascading.flow.hadoop.HadoopFlowProcess;
import cascading.flow.hadoop.stream.HadoopGroupGate;
import cascading.flow.hadoop.stream.element.HadoopCoGroupGate;
import cascading.flow.hadoop.stream.element.HadoopGroupByGate;
import cascading.flow.hadoop.stream.element.HadoopSinkStage;
import cascading.flow.stream.duct.Duct;
import cascading.flow.stream.duct.Gate;
import cascading.flow.stream.element.SinkStage;
import cascading.flow.stream.graph.IORole;
import cascading.flow.stream.graph.NodeStreamGraph;
import cascading.pipe.CoGroup;
import cascading.pipe.Group;
import cascading.pipe.GroupBy;
import cascading.pipe.HashJoin;
import cascading.tap.Tap;
import cascading.util.Util;
import java.util.Collection;

public class HadoopReduceStreamGraph
extends NodeStreamGraph {
    public HadoopReduceStreamGraph(HadoopFlowProcess flowProcess, FlowNode node, FlowElement sourceElement) {
        super((FlowProcess)flowProcess, node, sourceElement);
        this.buildGraph();
        this.setTraps();
        this.setScopes();
        this.printGraph(node.getID(), "reduce", flowProcess.getCurrentSliceNum());
        this.bind();
        this.printBoundGraph(node.getID(), "reduce", flowProcess.getCurrentSliceNum());
    }

    protected void buildGraph() {
        Group group = (Group)Util.getFirst((Collection)this.node.getSourceElements());
        HadoopGroupGate rhsDuct = group.isGroupBy() ? new HadoopGroupByGate(this.flowProcess, (GroupBy)group, IORole.source) : new HadoopCoGroupGate(this.flowProcess, (CoGroup)group, IORole.source);
        this.addHead((Duct)rhsDuct);
        this.handleDuct((FlowElement)group, (Duct)rhsDuct);
    }

    protected SinkStage createSinkStage(Tap element) {
        return new HadoopSinkStage(this.flowProcess, element);
    }

    protected Gate createCoGroupGate(CoGroup element, IORole role) {
        throw new IllegalStateException("should not happen");
    }

    protected Gate createGroupByGate(GroupBy element, IORole role) {
        throw new IllegalStateException("should not happen");
    }

    protected Gate createHashJoinGate(HashJoin join) {
        throw new IllegalStateException("should not happen");
    }
}

