/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.hadoop.stream.element;

import cascading.flow.FlowProcess;
import cascading.flow.hadoop.HadoopCoGroupClosure;
import cascading.flow.hadoop.HadoopFlowProcess;
import cascading.flow.hadoop.stream.HadoopGroupGate;
import cascading.flow.stream.duct.Duct;
import cascading.flow.stream.graph.IORole;
import cascading.flow.stream.graph.StreamGraph;
import cascading.pipe.CoGroup;
import cascading.pipe.Splice;
import cascading.tuple.Tuple;
import cascading.tuple.io.IndexTuple;
import cascading.tuple.io.KeyIndexTuple;
import cascading.tuple.io.ValueIndexTuple;
import java.io.IOException;
import org.apache.hadoop.mapred.OutputCollector;

public class HadoopCoGroupGate
extends HadoopGroupGate {
    IndexTuple keyTuple = new KeyIndexTuple();
    IndexTuple valueTuple = new ValueIndexTuple();

    public HadoopCoGroupGate(FlowProcess flowProcess, CoGroup coGroup, IORole role) {
        super(flowProcess, (Splice)coGroup, role);
    }

    public void bind(StreamGraph streamGraph) {
        super.bind(streamGraph);
    }

    protected HadoopCoGroupClosure createClosure() {
        return new HadoopCoGroupClosure(this.flowProcess, this.splice.getNumSelfJoins(), this.keyFields, this.valuesFields);
    }

    protected void wrapGroupingAndCollect(Duct previous, int ordinal, Tuple valuesTuple, Tuple groupKey) throws IOException {
        this.keyTuple.setIndex(ordinal);
        this.keyTuple.setTuple(groupKey);
        this.valueTuple.setIndex(ordinal);
        this.valueTuple.setTuple(valuesTuple);
        this.collector.collect((Object)this.keyTuple, (Object)this.valueTuple);
    }

    protected Tuple unwrapGrouping(Tuple key) {
        return ((IndexTuple)key).getTuple();
    }

    protected OutputCollector createOutputCollector() {
        return ((HadoopFlowProcess)this.flowProcess).getOutputCollector();
    }
}

