/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.hadoop;

import cascading.flow.hadoop.BaseMapReduceFlow;
import cascading.flow.hadoop.MapReduceFlowStep;
import cascading.flow.hadoop.util.HadoopUtil;
import cascading.flow.planner.PlatformInfo;
import cascading.flow.planner.graph.ElementGraphs;
import cascading.flow.planner.process.FlowStepGraph;
import cascading.flow.planner.process.ProcessModel;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;

public class MultiMapReduceFlow
extends BaseMapReduceFlow {
    private Map<String, Tap> tapCache = new HashMap<String, Tap>();
    private List<MapReduceFlowStep> queuedSteps = new LinkedList<MapReduceFlowStep>();
    private volatile boolean completeCalled = false;
    private final Object lock = new Object();

    public MultiMapReduceFlow(String name, JobConf jobConf, JobConf ... jobConfs) {
        this(HadoopUtil.getPlatformInfo(JobConf.class, (String)"org/apache/hadoop", (String)"Hadoop MR"), new Properties(), name);
        this.initializeFrom(Util.asList((Object)jobConf, (Object[])jobConfs));
    }

    public MultiMapReduceFlow(Map<Object, Object> properties, String name, JobConf jobConf, JobConf ... jobConfs) {
        this(HadoopUtil.getPlatformInfo(JobConf.class, (String)"org/apache/hadoop", (String)"Hadoop MR"), properties, name, null);
        this.initializeFrom(Util.asList((Object)jobConf, (Object[])jobConfs));
    }

    public MultiMapReduceFlow(Map<Object, Object> properties, String name, Map<String, String> flowDescriptor, JobConf jobConf, JobConf ... jobConfs) {
        this(HadoopUtil.getPlatformInfo(JobConf.class, (String)"org/apache/hadoop", (String)"Hadoop MR"), properties, name, flowDescriptor);
        this.initializeFrom(Util.asList((Object)jobConf, (Object[])jobConfs));
    }

    public MultiMapReduceFlow(Map<Object, Object> properties, String name, Map<String, String> flowDescriptor, boolean stopJobsOnExit, JobConf jobConf, JobConf ... jobConfs) {
        this(HadoopUtil.getPlatformInfo(JobConf.class, (String)"org/apache/hadoop", (String)"Hadoop MR"), properties, name, flowDescriptor);
        this.stopJobsOnExit = stopJobsOnExit;
        this.initializeFrom(Util.asList((Object)jobConf, (Object[])jobConfs));
    }

    protected MultiMapReduceFlow(PlatformInfo platformInfo, Map<Object, Object> properties, String name) {
        this(platformInfo, properties, name, null);
    }

    protected MultiMapReduceFlow(PlatformInfo platformInfo, Map<Object, Object> properties, String name, Map<String, String> flowDescriptor) {
        super(platformInfo, properties, name, flowDescriptor, false);
    }

    protected void initializeFrom(List<JobConf> jobConfs) {
        ArrayList<MapReduceFlowStep> steps = new ArrayList<MapReduceFlowStep>();
        for (JobConf jobConf : jobConfs) {
            steps.add(this.createMapReduceFlowStep(jobConf));
        }
        this.updateWithFlowSteps(steps);
    }

    protected MapReduceFlowStep createMapReduceFlowStep(JobConf jobConf) {
        return new MapReduceFlowStep(this, jobConf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyComplete() {
        this.completeCalled = true;
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    public void complete() {
        this.notifyComplete();
        super.complete();
    }

    protected boolean spawnSteps() throws InterruptedException, ExecutionException {
        while (!this.stop && this.throwable == null) {
            if (!this.blockingContinuePollingSteps()) {
                return true;
            }
            if (this.isInfoEnabled()) {
                this.logInfo("updated", new Object[0]);
                for (Tap source : this.getSourcesCollection()) {
                    this.logInfo(" source: " + source, new Object[0]);
                }
                for (Tap sink : this.getSinksCollection()) {
                    this.logInfo(" sink: " + sink, new Object[0]);
                }
            }
            if (super.spawnSteps()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean blockingContinuePollingSteps() {
        Object object = this.lock;
        synchronized (object) {
            while (this.queuedSteps.isEmpty() && !this.completeCalled) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.updateWithFlowSteps(this.queuedSteps).clear();
        }
        if (this.getEligibleJobsSize() != 0) {
            return true;
        }
        return !this.completeCalled;
    }

    @Override
    protected Tap createTap(JobConf jobConf, Path path, SinkMode sinkMode) {
        Tap tap = this.tapCache.get(path.toString());
        if (tap == null) {
            tap = super.createTap(jobConf, path, sinkMode);
            this.tapCache.put(path.toString(), tap);
        }
        return tap;
    }

    public void attachFlowStep(JobConf jobConf) {
        if (this.completeCalled) {
            throw new IllegalStateException("cannot attach new FlowStep after complete() has been called");
        }
        this.addFlowStep(this.createMapReduceFlowStep(jobConf));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFlowStep(MapReduceFlowStep flowStep) {
        Object object = this.lock;
        synchronized (object) {
            this.queuedSteps.add(flowStep);
            this.lock.notifyAll();
        }
    }

    protected FlowStepGraph getOrCreateFlowStepGraph() {
        FlowStepGraph flowStepGraph = this.getFlowStepGraph();
        if (flowStepGraph == null) {
            flowStepGraph = new FlowStepGraph();
            this.setFlowStepGraph(flowStepGraph);
        }
        return flowStepGraph;
    }

    protected Collection<MapReduceFlowStep> updateWithFlowSteps(Collection<MapReduceFlowStep> flowSteps) {
        if (flowSteps.isEmpty()) {
            return flowSteps;
        }
        FlowStepGraph flowStepGraph = this.getOrCreateFlowStepGraph();
        this.updateFlowStepGraph(flowStepGraph, flowSteps);
        this.setFlowElementGraph(ElementGraphs.asFlowElementGraph((PlatformInfo)this.platformInfo, (FlowStepGraph)flowStepGraph));
        this.removeListeners(this.getSourcesCollection());
        this.removeListeners(this.getSinksCollection());
        this.removeListeners(this.getTrapsCollection());
        this.setSources(flowStepGraph.getSourceTapsMap());
        this.setSinks(flowStepGraph.getSinkTapsMap());
        this.setTraps(flowStepGraph.getTrapsMap());
        this.initSteps();
        if (this.flowStats == null) {
            this.flowStats = this.createPrepareFlowStats();
        }
        if (!this.isJobsMapInitialized()) {
            this.initializeNewJobsMap();
        } else {
            this.updateJobsMap();
        }
        this.initializeChildStats();
        return flowSteps;
    }

    protected FlowStepGraph updateFlowStepGraph(FlowStepGraph flowStepGraph, Collection<MapReduceFlowStep> flowSteps) {
        for (MapReduceFlowStep flowStep : flowSteps) {
            flowStepGraph.addVertex((ProcessModel)flowStep);
        }
        flowStepGraph.bindEdges();
        return flowStepGraph;
    }
}

