/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.hadoop;

import cascading.flow.hadoop.BaseMapReduceFlow;
import cascading.flow.hadoop.util.HadoopUtil;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.mapred.JobConf;

public class MapReduceFlow
extends BaseMapReduceFlow {
    @ConstructorProperties(value={"jobConf"})
    public MapReduceFlow(JobConf jobConf) {
        this(jobConf.getJobName(), jobConf, false);
    }

    @ConstructorProperties(value={"jobConf", "deleteSinkOnInit"})
    public MapReduceFlow(JobConf jobConf, boolean deleteSinkOnInit) {
        this(jobConf.getJobName(), jobConf, deleteSinkOnInit);
    }

    @ConstructorProperties(value={"name", "jobConf"})
    public MapReduceFlow(String name, JobConf jobConf) {
        this(name, jobConf, false);
    }

    @ConstructorProperties(value={"name", "jobConf", "deleteSinkOnInit"})
    public MapReduceFlow(String name, JobConf jobConf, boolean deleteSinkOnInit) {
        this(new Properties(), name, jobConf, null, deleteSinkOnInit, true);
    }

    @ConstructorProperties(value={"properties", "name", "jobConf", "deleteSinkOnInit"})
    public MapReduceFlow(Properties properties, String name, JobConf jobConf, boolean deleteSinkOnInit) {
        this(properties, name, jobConf, null, deleteSinkOnInit, true);
    }

    @ConstructorProperties(value={"properties", "name", "jobConf", "flowDescriptor", "deleteSinkOnInit"})
    public MapReduceFlow(Properties properties, String name, JobConf jobConf, Map<String, String> flowDescriptor, boolean deleteSinkOnInit) {
        this(properties, name, jobConf, flowDescriptor, deleteSinkOnInit, true);
    }

    @ConstructorProperties(value={"properties", "name", "jobConf", "flowDescriptor", "deleteSinkOnInit", "stopJobsOnExit"})
    public MapReduceFlow(Properties properties, String name, JobConf jobConf, Map<String, String> flowDescriptor, boolean deleteSinkOnInit, boolean stopJobsOnExit) {
        super(HadoopUtil.getPlatformInfo(JobConf.class, (String)"org/apache/hadoop", (String)"Hadoop MR"), properties, jobConf, name, flowDescriptor, deleteSinkOnInit);
        this.stopJobsOnExit = stopJobsOnExit;
        this.initializeFrom(jobConf);
    }

    protected void initializeFrom(JobConf jobConf) {
        this.setSources(this.createSources(jobConf));
        this.setSinks(this.createSinks(jobConf));
        this.setTraps(this.createTraps(jobConf));
        this.setFlowStepGraph(this.makeStepGraph(jobConf));
        this.initSteps();
        this.flowStats = this.createPrepareFlowStats();
        this.initializeNewJobsMap();
        this.initializeChildStats();
    }
}

