/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.hadoop;

import cascading.CascadingException;
import cascading.flow.FlowElement;
import cascading.flow.FlowException;
import cascading.flow.FlowNode;
import cascading.flow.FlowProcess;
import cascading.flow.FlowSession;
import cascading.flow.SliceCounters;
import cascading.flow.StepCounters;
import cascading.flow.hadoop.HadoopFlowProcess;
import cascading.flow.hadoop.planner.HadoopFlowStepJob;
import cascading.flow.hadoop.stream.HadoopGroupGate;
import cascading.flow.hadoop.stream.graph.HadoopReduceStreamGraph;
import cascading.flow.hadoop.util.HadoopMRUtil;
import cascading.flow.hadoop.util.HadoopUtil;
import cascading.flow.hadoop.util.TimedIterator;
import cascading.flow.planner.BaseFlowNode;
import cascading.flow.stream.StopDataNotificationException;
import cascading.flow.stream.duct.Duct;
import cascading.flow.stream.element.ElementDuct;
import cascading.tap.Tap;
import cascading.tuple.Tuple;
import cascading.util.LogUtil;
import cascading.util.Util;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowReducer
extends MapReduceBase
implements Reducer {
    private static final Logger LOG = LoggerFactory.getLogger(FlowReducer.class);
    private FlowNode flowNode;
    private HadoopReduceStreamGraph streamGraph;
    private HadoopFlowProcess currentProcess;
    private TimedIterator<Tuple>[] timedIterators;
    private boolean calledPrepare = false;
    private HadoopGroupGate group;
    private long processBeginTime;

    public void configure(JobConf jobConf) {
        try {
            super.configure(jobConf);
            HadoopUtil.initLog4j((JobConf)jobConf);
            LOG.info("cascading version: {}", (Object)jobConf.get("cascading.version", ""));
            LOG.info("child jvm opts: {}", (Object)jobConf.get("mapred.child.java.opts", ""));
            this.currentProcess = new HadoopFlowProcess(new FlowSession(), jobConf, false);
            this.timedIterators = TimedIterator.iterators((TimedIterator[])new TimedIterator[]{new TimedIterator((FlowProcess)this.currentProcess, (Enum)SliceCounters.Read_Duration, (Enum)SliceCounters.Tuples_Read)});
            String reduceNodeState = jobConf.getRaw("cascading.flow.step.node.reduce");
            if (reduceNodeState == null) {
                reduceNodeState = HadoopMRUtil.readStateFromDistCache(jobConf, jobConf.get("cascading.flow.step.id"), "reduce");
            }
            this.flowNode = (FlowNode)HadoopUtil.deserializeBase64((String)reduceNodeState, (Configuration)jobConf, BaseFlowNode.class);
            LOG.info("flow node id: {}, ordinal: {}", (Object)this.flowNode.getID(), (Object)this.flowNode.getOrdinal());
            this.streamGraph = new HadoopReduceStreamGraph(this.currentProcess, this.flowNode, (FlowElement)Util.getFirst((Collection)this.flowNode.getSourceElements()));
            this.group = (HadoopGroupGate)this.streamGraph.getHeads().iterator().next();
            for (Duct head : this.streamGraph.getHeads()) {
                LOG.info("sourcing from: " + ((ElementDuct)head).getFlowElement());
            }
            for (Duct tail : this.streamGraph.getTails()) {
                LOG.info("sinking to: " + ((ElementDuct)tail).getFlowElement());
            }
            for (Tap trap : this.flowNode.getTraps()) {
                LOG.info("trapping to: " + trap);
            }
            LogUtil.logMemory((Logger)LOG, (String)("flow node id: " + this.flowNode.getID() + ", mem on start"));
        }
        catch (Throwable throwable) {
            this.reportIfLocal(throwable);
            if (throwable instanceof CascadingException) {
                throw (CascadingException)throwable;
            }
            throw new FlowException("internal error during reducer configuration", throwable);
        }
    }

    public void reduce(Object key, Iterator values, OutputCollector output, Reporter reporter) throws IOException {
        this.currentProcess.setReporter(reporter);
        this.currentProcess.setOutputCollector(output);
        this.timedIterators[0].reset(values);
        if (!this.calledPrepare) {
            this.streamGraph.prepare();
            this.calledPrepare = true;
            this.processBeginTime = System.currentTimeMillis();
            this.currentProcess.increment((Enum)SliceCounters.Process_Begin_Time, this.processBeginTime);
            this.currentProcess.increment((Enum)StepCounters.Process_Begin_Time, this.processBeginTime);
            this.group.start((Duct)this.group);
        }
        try {
            this.group.accept((Tuple)key, this.timedIterators);
        }
        catch (StopDataNotificationException exception) {
            LogUtil.logWarnOnce((Logger)LOG, (String)"received unsupported stop data notification, ignoring: {}", (Object)exception.getMessage());
        }
        catch (OutOfMemoryError error) {
            throw error;
        }
        catch (Throwable throwable) {
            this.reportIfLocal(throwable);
            if (throwable instanceof CascadingException) {
                throw (CascadingException)throwable;
            }
            throw new FlowException("internal error during reducer execution", throwable);
        }
    }

    public void close() throws IOException {
        try {
            if (this.calledPrepare) {
                this.group.complete((Duct)this.group);
                this.streamGraph.cleanup();
            }
            super.close();
        }
        finally {
            if (this.currentProcess != null) {
                long processEndTime = System.currentTimeMillis();
                this.currentProcess.increment((Enum)SliceCounters.Process_End_Time, processEndTime);
                this.currentProcess.increment((Enum)SliceCounters.Process_Duration, processEndTime - this.processBeginTime);
                this.currentProcess.increment((Enum)StepCounters.Process_End_Time, processEndTime);
                this.currentProcess.increment((Enum)StepCounters.Process_Duration, processEndTime - this.processBeginTime);
            }
            String message = "flow node id: " + this.flowNode.getID();
            LogUtil.logMemory((Logger)LOG, (String)(message + ", mem on close"));
            LogUtil.logCounters((Logger)LOG, (String)(message + ", counter:"), (FlowProcess)this.currentProcess);
        }
    }

    private void reportIfLocal(Throwable throwable) {
        if (HadoopUtil.isLocal((Configuration)this.currentProcess.getJobConf())) {
            HadoopFlowStepJob.reportLocalError(throwable);
        }
    }
}

