/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.hadoop;

import cascading.CascadingException;
import cascading.flow.FlowStep;
import cascading.flow.hadoop.HadoopFlow;
import cascading.flow.hadoop.MapReduceFlowStep;
import cascading.flow.planner.PlatformInfo;
import cascading.flow.planner.process.FlowStepGraph;
import cascading.scheme.NullScheme;
import cascading.scheme.Scheme;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tap.hadoop.Hfs;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public class BaseMapReduceFlow
extends HadoopFlow {
    protected boolean deleteSinkOnInit = false;

    protected BaseMapReduceFlow(PlatformInfo platformInfo, Map<Object, Object> properties, JobConf jobConf, String name, Map<String, String> flowDescriptor, boolean deleteSinkOnInit) {
        super(platformInfo, properties, jobConf, name, flowDescriptor);
        this.deleteSinkOnInit = deleteSinkOnInit;
    }

    protected BaseMapReduceFlow(PlatformInfo platformInfo, Map<Object, Object> properties, String name, Map<String, String> flowDescriptor, boolean deleteSinkOnInit) {
        super(platformInfo, properties, new JobConf(), name, flowDescriptor);
        this.deleteSinkOnInit = deleteSinkOnInit;
    }

    protected FlowStepGraph makeStepGraph(JobConf jobConf) {
        FlowStepGraph flowStepGraph = new FlowStepGraph();
        Tap sink = (Tap)this.getSinksCollection().iterator().next();
        FlowStep<JobConf> step = this.createFlowStep(jobConf, sink);
        flowStepGraph.addVertex(step);
        return flowStepGraph;
    }

    protected FlowStep<JobConf> createFlowStep(JobConf jobConf, Tap sink) {
        return new MapReduceFlowStep(this, sink.toString(), jobConf, sink);
    }

    protected Map<String, Tap> createSources(JobConf jobConf) {
        return this.fileInputToTaps(jobConf);
    }

    protected Map<String, Tap> fileInputToTaps(JobConf jobConf) {
        Path[] paths = FileInputFormat.getInputPaths((JobConf)jobConf);
        if (paths == null || paths.length == 0) {
            try {
                paths = org.apache.hadoop.mapreduce.lib.input.FileInputFormat.getInputPaths((JobContext)new Job((Configuration)jobConf));
            }
            catch (IOException exception) {
                throw new CascadingException((Throwable)exception);
            }
        }
        HashMap<String, Tap> taps = new HashMap<String, Tap>();
        if (paths == null) {
            return taps;
        }
        for (Path path : paths) {
            this.toSourceTap(jobConf, taps, path);
        }
        return taps;
    }

    protected Tap toSourceTap(JobConf jobConf, Map<String, Tap> taps, Path path) {
        String name = this.makeNameFromPath(taps, path);
        return taps.put(name, this.createTap(jobConf, path, SinkMode.KEEP));
    }

    protected Map<String, Tap> createSinks(JobConf jobConf) {
        return this.fileOutputToTaps(jobConf);
    }

    protected Map<String, Tap> fileOutputToTaps(JobConf jobConf) {
        Path path = org.apache.hadoop.mapred.FileOutputFormat.getOutputPath((JobConf)jobConf);
        if (path == null) {
            try {
                path = FileOutputFormat.getOutputPath((JobContext)new Job((Configuration)jobConf));
            }
            catch (IOException exception) {
                throw new CascadingException((Throwable)exception);
            }
        }
        HashMap<String, Tap> taps = new HashMap<String, Tap>();
        if (path != null) {
            this.toSinkTap(jobConf, taps, path);
        }
        return taps;
    }

    protected Tap toSinkTap(JobConf jobConf, Map<String, Tap> taps, Path path) {
        String name = this.makeNameFromPath(taps, path);
        SinkMode sinkMode = this.deleteSinkOnInit ? SinkMode.REPLACE : SinkMode.KEEP;
        return taps.put(name, this.createTap(jobConf, path, sinkMode));
    }

    protected Tap createTap(JobConf jobConf, Path path, SinkMode sinkMode) {
        return new Hfs((Scheme)new NullScheme(), path.toString(), sinkMode);
    }

    protected String makeNameFromPath(Map<String, Tap> taps, Path path) {
        Path parent = path.getParent();
        String name = path.getName();
        while (taps.containsKey(name)) {
            name = new Path(parent.getName(), name).toString();
            parent = parent.getParent();
        }
        return name;
    }

    protected Map<String, Tap> createTraps(JobConf jobConf) {
        return new HashMap<String, Tap>();
    }
}

