/*
 * Decompiled with CFR 0.152.
 */
package cascading.stats.hadoop;

import cascading.PlatformTestCase;
import cascading.cascade.Cascade;
import cascading.cascade.CascadeConnector;
import cascading.flow.Flow;
import cascading.flow.SliceCounters;
import cascading.operation.Filter;
import cascading.operation.Function;
import cascading.operation.regex.RegexParser;
import cascading.operation.state.Counter;
import cascading.pipe.Each;
import cascading.pipe.GroupBy;
import cascading.pipe.Pipe;
import cascading.stats.CascadeStats;
import cascading.stats.FlowNodeStats;
import cascading.stats.FlowSliceStats;
import cascading.stats.FlowStats;
import cascading.stats.FlowStepStats;
import cascading.stats.hadoop.HadoopSliceStats;
import cascading.stats.hadoop.HadoopStepStats;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import data.InputData;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.junit.Test;

public class HadoopStatsPlatformTest
extends PlatformTestCase {
    public HadoopStatsPlatformTest() {
        super(true);
    }

    @Test
    public void testStatsCounters() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(InputData.inputFileApache);
        Pipe pipe = new Pipe("first");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new RegexParser(new Fields(new Comparable[]{"ip"}), "^[^ ]*"), new Fields(new Comparable[]{"ip"}));
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"ip"}));
        pipe = new Each(pipe, (Filter)new Counter((Enum)TestEnum.FIRST));
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"ip"}));
        pipe = new Each(pipe, (Filter)new Counter((Enum)TestEnum.FIRST));
        pipe = new Each(pipe, (Filter)new Counter((Enum)TestEnum.SECOND));
        Tap sink1 = this.getPlatform().getTextFile(this.getOutputPath("flowstats1"), SinkMode.REPLACE);
        Tap sink2 = this.getPlatform().getTextFile(this.getOutputPath("flowstats2"), SinkMode.REPLACE);
        Flow flow1 = this.getPlatform().getFlowConnector().connect("stats1 test", source, sink1, pipe);
        Flow flow2 = this.getPlatform().getFlowConnector().connect("stats2 test", source, sink2, pipe);
        Cascade cascade = new CascadeConnector(this.getProperties()).connect(new Flow[]{flow1, flow2});
        cascade.complete();
        CascadeStats cascadeStats = cascade.getCascadeStats();
        HadoopStatsPlatformTest.assertNotNull((Object)cascadeStats.getID());
        HadoopStatsPlatformTest.assertEquals((int)1, (int)cascadeStats.getCounterGroupsMatching("cascading\\.stats\\..*").size());
        HadoopStatsPlatformTest.assertEquals((int)2, (int)cascadeStats.getCountersFor(TestEnum.class.getName()).size());
        HadoopStatsPlatformTest.assertEquals((int)2, (int)cascadeStats.getCountersFor(TestEnum.class).size());
        HadoopStatsPlatformTest.assertEquals((long)40L, (long)cascadeStats.getCounterValue((Enum)TestEnum.FIRST));
        HadoopStatsPlatformTest.assertEquals((long)20L, (long)cascadeStats.getCounterValue((Enum)TestEnum.SECOND));
        HadoopStatsPlatformTest.assertEquals((long)0L, (long)cascadeStats.getCounterValue((Enum)TestEnum.THIRD));
        HadoopStatsPlatformTest.assertEquals((long)0L, (long)cascadeStats.getCounterValue("FOO", "BAR"));
        FlowStats flowStats1 = flow1.getFlowStats();
        HadoopStatsPlatformTest.assertNotNull((Object)flowStats1.getID());
        HadoopStatsPlatformTest.assertEquals((long)20L, (long)flowStats1.getCounterValue((Enum)TestEnum.FIRST));
        HadoopStatsPlatformTest.assertEquals((long)10L, (long)flowStats1.getCounterValue((Enum)TestEnum.SECOND));
        HadoopStatsPlatformTest.assertEquals((long)10L, (long)((FlowStepStats)flowStats1.getFlowStepStats().get(0)).getCounterValue((Enum)TestEnum.FIRST));
        HadoopStatsPlatformTest.assertEquals((long)10L, (long)((FlowStepStats)flowStats1.getFlowStepStats().get(1)).getCounterValue((Enum)TestEnum.FIRST));
        HadoopStatsPlatformTest.assertEquals((long)0L, (long)flowStats1.getCounterValue((Enum)TestEnum.THIRD));
        HadoopStatsPlatformTest.assertEquals((long)0L, (long)flowStats1.getCounterValue("FOO", "BAR"));
        FlowStats flowStats2 = flow2.getFlowStats();
        HadoopStatsPlatformTest.assertNotNull((Object)flowStats2.getID());
        HadoopStatsPlatformTest.assertEquals((long)20L, (long)flowStats2.getCounterValue((Enum)TestEnum.FIRST));
        HadoopStatsPlatformTest.assertEquals((long)10L, (long)flowStats2.getCounterValue((Enum)TestEnum.SECOND));
        cascadeStats.captureDetail();
        HadoopStatsPlatformTest.assertEquals((int)2, (int)flowStats1.getStepsCount());
        HadoopStatsPlatformTest.assertEquals((int)2, (int)flowStats2.getStepsCount());
        HadoopStepStats stats1 = (HadoopStepStats)flowStats1.getFlowStepStats().get(0);
        HadoopStatsPlatformTest.assertNotNull((Object)stats1.getID());
        HadoopStatsPlatformTest.assertNotNull((Object)stats1.getProcessStepID());
        if (this.getPlatform().isUseCluster()) {
            HadoopStatsPlatformTest.assertTrue((stats1.getCounterValue((Enum)SliceCounters.Process_Duration) != 0L ? 1 : 0) != 0);
            List flowNodeStats = stats1.getFlowNodeStats();
            HadoopStatsPlatformTest.assertTrue((((FlowNodeStats)flowNodeStats.get(0)).getCounterValue((Enum)SliceCounters.Process_Duration) != 0L ? 1 : 0) != 0);
            HadoopStatsPlatformTest.assertEquals((int)2, (int)flowNodeStats.size());
            HashMap statsMap = new HashMap();
            statsMap.put(((FlowNodeStats)flowNodeStats.get(0)).getKind(), flowNodeStats.get(0));
            statsMap.put(((FlowNodeStats)flowNodeStats.get(1)).getKind(), flowNodeStats.get(1));
            HadoopStatsPlatformTest.assertNotNull(statsMap.get("MAPPER"));
            HadoopStatsPlatformTest.assertNotNull(statsMap.get("REDUCER"));
            HadoopStatsPlatformTest.assertEquals((int)4, (int)((FlowNodeStats)statsMap.get("MAPPER")).getChildren().size());
            HadoopStatsPlatformTest.assertEquals((int)1, (int)((FlowNodeStats)statsMap.get("REDUCER")).getChildren().size());
            Collection children = ((FlowNodeStats)statsMap.get("REDUCER")).getChildren();
            for (FlowSliceStats flowSliceStats : children) {
                HadoopStatsPlatformTest.assertNotSame((Object)-1, (Object)flowSliceStats.getProcessStartTime());
                HadoopStatsPlatformTest.assertNotSame((Object)-1, (Object)flowSliceStats.getProcessSubmitTime());
                HadoopStatsPlatformTest.assertNotSame((Object)-1, (Object)flowSliceStats.getProcessRunTime());
                HadoopStatsPlatformTest.assertNotSame((Object)-1, (Object)flowSliceStats.getProcessFinishTime());
                HadoopStatsPlatformTest.assertTrue((flowSliceStats.getProcessStartTime() <= flowSliceStats.getProcessSubmitTime() ? 1 : 0) != 0);
                HadoopStatsPlatformTest.assertTrue((flowSliceStats.getProcessSubmitTime() <= flowSliceStats.getProcessRunTime() ? 1 : 0) != 0);
                HadoopStatsPlatformTest.assertTrue((flowSliceStats.getProcessRunTime() < flowSliceStats.getProcessFinishTime() ? 1 : 0) != 0);
                HadoopSliceStats hadoopSliceStats = (HadoopSliceStats)flowSliceStats;
                if (hadoopSliceStats.getTaskIDNum() != 0 || hadoopSliceStats.getKind() != HadoopSliceStats.Kind.REDUCER) continue;
                HadoopStatsPlatformTest.assertTrue((hadoopSliceStats.getCounterValue((Enum)TestEnum.FIRST) > 0L ? 1 : 0) != 0);
            }
        }
        HadoopStepStats stats2 = (HadoopStepStats)flowStats2.getFlowStepStats().get(0);
        HadoopStatsPlatformTest.assertNotNull((Object)stats2.getID());
        HadoopStatsPlatformTest.assertNotNull((Object)stats2.getProcessStepID());
        if (this.getPlatform().isUseCluster()) {
            List flowNodeStats = stats2.getFlowNodeStats();
            HadoopStatsPlatformTest.assertEquals((int)2, (int)flowNodeStats.size());
            HashMap statsMap = new HashMap();
            statsMap.put(((FlowNodeStats)flowNodeStats.get(0)).getKind(), flowNodeStats.get(0));
            statsMap.put(((FlowNodeStats)flowNodeStats.get(1)).getKind(), flowNodeStats.get(1));
            HadoopStatsPlatformTest.assertNotNull(statsMap.get("MAPPER"));
            HadoopStatsPlatformTest.assertNotNull(statsMap.get("REDUCER"));
            HadoopStatsPlatformTest.assertEquals((int)4, (int)((FlowNodeStats)statsMap.get("MAPPER")).getChildren().size());
            HadoopStatsPlatformTest.assertEquals((int)1, (int)((FlowNodeStats)statsMap.get("REDUCER")).getChildren().size());
        }
    }

    static enum TestEnum {
        FIRST,
        SECOND,
        THIRD;

    }
}

