/*
 * Decompiled with CFR 0.152.
 */
package cascading.stats.hadoop;

import cascading.flow.FlowException;
import cascading.flow.FlowNode;
import cascading.flow.FlowStep;
import cascading.flow.planner.BaseFlowStep;
import cascading.flow.planner.process.ProcessModel;
import cascading.management.state.ClientState;
import cascading.stats.BaseCachedStepStats;
import cascading.stats.CascadingStats;
import cascading.stats.FlowNodeStats;
import cascading.stats.hadoop.HadoopNodeStats;
import cascading.stats.hadoop.HadoopSliceStats;
import cascading.stats.hadoop.HadoopStepCounterCache;
import cascading.util.Util;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HadoopStepStats
extends BaseCachedStepStats<Configuration, RunningJob, Counters> {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopStepStats.class);
    private HadoopNodeStats mapperNodeStats;
    private HadoopNodeStats reducerNodeStats;

    protected static Job getJob(RunningJob runningJob) {
        if (runningJob == null) {
            return null;
        }
        Job job = (Job)Util.returnInstanceFieldIfExistsSafe((Object)runningJob, (String)"job");
        if (job == null) {
            LOG.warn("unable to get underlying org.apache.hadoop.mapreduce.Job from org.apache.hadoop.mapred.RunningJob, task level task counters will be unavailable");
            return null;
        }
        return job;
    }

    protected HadoopStepStats(FlowStep<JobConf> flowStep, ClientState clientState) {
        super(flowStep, clientState);
        BaseFlowStep step = (BaseFlowStep)flowStep;
        for (FlowNode current : step.getFlowNodeGraph().vertexSet()) {
            if (step.getFlowNodeGraph().inDegreeOf((ProcessModel)current) == 0) {
                if (this.mapperNodeStats != null) {
                    throw new IllegalStateException("mapper node already found");
                }
                this.mapperNodeStats = new HadoopNodeStats(this, this.getConfig(), HadoopSliceStats.Kind.MAPPER, current, clientState);
                this.addNodeStats((FlowNodeStats)this.mapperNodeStats);
                continue;
            }
            if (this.reducerNodeStats != null) {
                throw new IllegalStateException("reducer node already found");
            }
            this.reducerNodeStats = new HadoopNodeStats(this, this.getConfig(), HadoopSliceStats.Kind.REDUCER, current, clientState);
            this.addNodeStats((FlowNodeStats)this.reducerNodeStats);
        }
        if (this.mapperNodeStats == null) {
            throw new IllegalStateException("mapper node not found");
        }
        this.counterCache = new HadoopStepCounterCache((CascadingStats)this, this.getConfig()){

            protected RunningJob getJobStatusClient() {
                return (RunningJob)HadoopStepStats.this.getJobStatusClient();
            }
        };
    }

    private Configuration getConfig() {
        return (Configuration)this.getFlowStep().getConfig();
    }

    public int getNumMapTasks() {
        return this.mapperNodeStats.getChildren().size();
    }

    public int getNumReduceTasks() {
        return this.reducerNodeStats == null ? 0 : this.reducerNodeStats.getChildren().size();
    }

    public String getProcessStepID() {
        if (this.getJobStatusClient() == null) {
            return null;
        }
        return ((RunningJob)this.getJobStatusClient()).getJobID().toString();
    }

    public abstract JobClient getJobClient();

    public float getMapProgress() {
        Job runningJob = HadoopStepStats.getJob((RunningJob)this.getJobStatusClient());
        if (runningJob == null) {
            return 0.0f;
        }
        try {
            return runningJob.mapProgress();
        }
        catch (IOException exception) {
            throw new FlowException("unable to get progress");
        }
    }

    public float getReduceProgress() {
        Job runningJob = HadoopStepStats.getJob((RunningJob)this.getJobStatusClient());
        if (runningJob == null) {
            return 0.0f;
        }
        try {
            return runningJob.reduceProgress();
        }
        catch (IOException exception) {
            throw new FlowException("unable to get progress");
        }
    }

    public String getProcessStatusURL() {
        return this.getStatusURL();
    }

    @Deprecated
    public String getStatusURL() {
        Job runningJob = HadoopStepStats.getJob((RunningJob)this.getJobStatusClient());
        if (runningJob == null) {
            return null;
        }
        return runningJob.getTrackingURL();
    }

    public synchronized void captureDetail(CascadingStats.Type depth) {
        if (!this.getType().isChild(depth) || !this.isDetailStale()) {
            return;
        }
        Job runningJob = HadoopStepStats.getJob((RunningJob)this.getJobStatusClient());
        if (runningJob == null) {
            return;
        }
        try {
            TaskCompletionEvent[] events;
            this.mapperNodeStats.captureDetail(depth);
            if (this.reducerNodeStats != null) {
                this.reducerNodeStats.captureDetail(depth);
            }
            int count = 0;
            while (depth == CascadingStats.Type.ATTEMPT && (events = runningJob.getTaskCompletionEvents(count)).length != 0) {
                this.addAttemptsToTaskStats((org.apache.hadoop.mapreduce.TaskCompletionEvent[])events);
                count += events.length;
            }
            this.markDetailCaptured();
        }
        catch (IOException exception) {
            LOG.warn("unable to get task stats", (Throwable)exception);
        }
    }

    private void addAttemptsToTaskStats(org.apache.hadoop.mapreduce.TaskCompletionEvent[] events) {
        for (org.apache.hadoop.mapreduce.TaskCompletionEvent event : events) {
            if (event == null) {
                LOG.warn("found empty completion event");
                continue;
            }
            if (event.isMapTask()) {
                this.mapperNodeStats.addAttempt(event);
                continue;
            }
            this.reducerNodeStats.addAttempt(event);
        }
    }
}

