/*
 * Decompiled with CFR 0.152.
 */
package cascading.stats.hadoop;

import cascading.stats.CascadingStats;
import cascading.stats.hadoop.HadoopCounterCache;
import cascading.stats.hadoop.HadoopStepStats;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Counters;

public abstract class HadoopStepCounterCache
extends HadoopCounterCache<RunningJob, Counters> {
    protected HadoopStepCounterCache(CascadingStats stats, Configuration configuration) {
        super(stats, configuration);
    }

    protected boolean areCountersAvailable(RunningJob runningJob) {
        return true;
    }

    protected Counters getCounters(RunningJob runningJob) throws IOException {
        return HadoopStepStats.getJob(runningJob).getCounters();
    }

    protected Collection<String> getGroupNames(Counters groups) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String value : groups.getGroupNames()) {
            result.add(value);
        }
        return result;
    }

    protected Set<String> getCountersFor(Counters counters, String group) {
        HashSet<String> results = new HashSet<String>();
        for (Counter counter : (CounterGroup)counters.getGroup(group)) {
            results.add(counter.getName());
        }
        return results;
    }

    protected long getCounterValue(Counters counters, Enum counter) {
        Counter result = counters.findCounter(counter);
        if (result == null) {
            return 0L;
        }
        return result.getValue();
    }

    protected long getCounterValue(Counters counters, String groupName, String counterName) {
        CounterGroup counterGroup = (CounterGroup)counters.getGroup(groupName);
        if (counterGroup == null) {
            return 0L;
        }
        Counter counterValue = counterGroup.findCounter(counterName);
        if (counterValue == null) {
            return 0L;
        }
        return counterValue.getValue();
    }
}

