/*
 * Decompiled with CFR 0.152.
 */
package cascading.stats.hadoop;

import cascading.flow.hadoop.util.HadoopUtil;
import cascading.stats.CascadingStats;
import cascading.stats.FlowNodeStats;
import cascading.stats.FlowSliceStats;
import cascading.stats.hadoop.HadoopCounterCache;
import cascading.stats.hadoop.HadoopSliceStats;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.TaskReport;

public class HadoopNodeCounterCache
extends HadoopCounterCache<FlowNodeStats, Map<String, Map<String, Long>>> {
    private FlowNodeStats flowNodeStats;
    private Configuration configuration;

    protected HadoopNodeCounterCache(FlowNodeStats flowNodeStats, Configuration configuration) {
        super((CascadingStats)flowNodeStats, configuration);
        this.flowNodeStats = flowNodeStats;
        this.configuration = configuration;
    }

    protected FlowNodeStats getJobStatusClient() {
        return this.flowNodeStats;
    }

    protected boolean areCountersAvailable(FlowNodeStats runningJob) {
        return !HadoopUtil.isLocal((Configuration)this.configuration);
    }

    protected Map<String, Map<String, Long>> getCounters(FlowNodeStats flowNodeStats) throws IOException {
        flowNodeStats.captureDetail(CascadingStats.Type.SLICE);
        HashMap<String, Map<String, Long>> allCounters = new HashMap<String, Map<String, Long>>();
        Collection children = flowNodeStats.getChildren();
        for (FlowSliceStats sliceStats : children) {
            TaskReport taskReport = ((HadoopSliceStats)sliceStats).getTaskReport();
            Counters counters = taskReport.getTaskCounters();
            for (CounterGroup group : counters) {
                HashMap<String, Long> values = (HashMap<String, Long>)allCounters.get(group.getName());
                if (values == null) {
                    values = new HashMap<String, Long>();
                    allCounters.put(group.getName(), values);
                }
                for (Counter counter : group) {
                    Long value = (Long)values.get(counter.getName());
                    if (value == null) {
                        value = 0L;
                    }
                    value = value + counter.getValue();
                    values.put(counter.getName(), value);
                }
            }
        }
        return allCounters;
    }

    protected Collection<String> getGroupNames(Map<String, Map<String, Long>> groups) {
        return groups.keySet();
    }

    protected Set<String> getCountersFor(Map<String, Map<String, Long>> counters, String group) {
        HashSet<String> results = new HashSet<String>();
        Map<String, Long> map = counters.get(group);
        if (map != null) {
            results.addAll(map.keySet());
        }
        return results;
    }

    protected long getCounterValue(Map<String, Map<String, Long>> counters, Enum counter) {
        return this.getCounterValue(counters, counter.getDeclaringClass().getName(), counter.name());
    }

    protected long getCounterValue(Map<String, Map<String, Long>> counters, String groupName, String counterName) {
        Map<String, Long> counterGroup = counters.get(groupName);
        if (counterGroup == null) {
            return 0L;
        }
        Long counterValue = counterGroup.get(counterName);
        if (counterValue == null) {
            return 0L;
        }
        return counterValue;
    }
}

