/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.hadoop.stream.graph;

import cascading.flow.FlowElement;
import cascading.flow.FlowException;
import cascading.flow.FlowNode;
import cascading.flow.FlowProcess;
import cascading.flow.hadoop.HadoopFlowProcess;
import cascading.flow.hadoop.stream.HadoopMemoryJoinGate;
import cascading.flow.hadoop.stream.element.HadoopCoGroupGate;
import cascading.flow.hadoop.stream.element.HadoopGroupByGate;
import cascading.flow.hadoop.stream.element.HadoopSinkStage;
import cascading.flow.hadoop.util.HadoopUtil;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.graph.ElementGraphs;
import cascading.flow.stream.duct.Duct;
import cascading.flow.stream.duct.Gate;
import cascading.flow.stream.element.GroupingSpliceGate;
import cascading.flow.stream.element.SinkStage;
import cascading.flow.stream.element.SourceStage;
import cascading.flow.stream.graph.IORole;
import cascading.flow.stream.graph.NodeStreamGraph;
import cascading.pipe.CoGroup;
import cascading.pipe.GroupBy;
import cascading.pipe.HashJoin;
import cascading.tap.Tap;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;

public class HadoopMapStreamGraph
extends NodeStreamGraph {
    private final Tap source;
    private SourceStage streamedHead;

    public HadoopMapStreamGraph(HadoopFlowProcess flowProcess, FlowNode node, Tap source) {
        super((FlowProcess)flowProcess, node, (FlowElement)source);
        this.source = source;
        this.buildGraph();
        this.setTraps();
        this.setScopes();
        this.printGraph(node.getID(), "map", flowProcess.getCurrentSliceNum());
        this.bind();
        this.printBoundGraph(node.getID(), "map", flowProcess.getCurrentSliceNum());
    }

    public SourceStage getStreamedHead() {
        return this.streamedHead;
    }

    protected void buildGraph() {
        this.streamedHead = this.handleHead(this.source, this.flowProcess);
        Set tributaries = ElementGraphs.findSources((ElementGraph)this.elementGraph, Tap.class);
        tributaries.remove(this.source);
        for (Object source : tributaries) {
            final HadoopFlowProcess hadoopProcess = (HadoopFlowProcess)this.flowProcess;
            JobConf conf = hadoopProcess.getJobConf();
            String property = conf.getRaw("cascading.node.accumulated.source.conf." + Tap.id((Tap)((Tap)source)));
            if (property == null) {
                throw new IllegalStateException("accumulated source conf property missing for: " + ((Tap)source).getIdentifier());
            }
            conf = this.getSourceConf(hadoopProcess, conf, property);
            this.flowProcess = new HadoopFlowProcess(hadoopProcess, conf){

                @Override
                public Reporter getReporter() {
                    return hadoopProcess.getReporter();
                }
            };
            this.handleHead((Tap)source, this.flowProcess);
        }
    }

    private JobConf getSourceConf(HadoopFlowProcess flowProcess, JobConf conf, String property) {
        Map priorConf;
        try {
            priorConf = (Map)HadoopUtil.deserializeBase64((String)property, (Configuration)conf, HashMap.class, (boolean)true);
        }
        catch (IOException exception) {
            throw new FlowException("unable to deserialize properties", (Throwable)exception);
        }
        return flowProcess.mergeMapIntoConfig(conf, (Map<String, String>)priorConf);
    }

    private SourceStage handleHead(Tap source, FlowProcess flowProcess) {
        SourceStage sourceDuct = new SourceStage(flowProcess, source);
        this.addHead((Duct)sourceDuct);
        this.handleDuct((FlowElement)source, (Duct)sourceDuct);
        return sourceDuct;
    }

    protected SinkStage createSinkStage(Tap element) {
        return new HadoopSinkStage(this.flowProcess, element);
    }

    protected Gate createCoGroupGate(CoGroup element, IORole role) {
        return new HadoopCoGroupGate(this.flowProcess, element, IORole.sink);
    }

    protected Gate createGroupByGate(GroupBy element, IORole role) {
        return new HadoopGroupByGate(this.flowProcess, element, role);
    }

    protected GroupingSpliceGate createNonBlockingJoinGate(HashJoin join) {
        return new HadoopMemoryJoinGate(this.flowProcess, join);
    }
}

