/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.hadoop.planner;

import cascading.flow.FlowConnector;
import cascading.flow.FlowDef;
import cascading.flow.FlowStep;
import cascading.flow.hadoop.HadoopFlow;
import cascading.flow.hadoop.HadoopFlowStep;
import cascading.flow.hadoop.util.HadoopUtil;
import cascading.flow.planner.BaseFlowStepFactory;
import cascading.flow.planner.FlowPlanner;
import cascading.flow.planner.PlannerInfo;
import cascading.flow.planner.PlatformInfo;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.iso.transformer.ElementFactory;
import cascading.flow.planner.process.FlowNodeGraph;
import cascading.flow.planner.process.FlowStepFactory;
import cascading.flow.planner.rule.RuleRegistry;
import cascading.property.AppProps;
import cascading.property.PropertyUtil;
import cascading.tap.Tap;
import cascading.tap.hadoop.DistCacheTap;
import cascading.tap.hadoop.Hfs;
import cascading.tap.hadoop.util.TempHfs;
import cascading.util.Util;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopPlanner
extends FlowPlanner<HadoopFlow, JobConf> {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopPlanner.class);
    public static final String PLATFORM_NAME = "hadoop";
    private JobConf defaultJobConf;
    private Class intermediateSchemeClass;

    public static void copyJobConf(Map<Object, Object> properties, JobConf jobConf) {
        for (Map.Entry entry : jobConf) {
            properties.put(entry.getKey(), entry.getValue());
        }
    }

    public static JobConf createJobConf(Map<Object, Object> properties) {
        JobConf conf = new JobConf();
        HadoopPlanner.copyProperties(conf, properties);
        return conf;
    }

    public static void copyProperties(JobConf jobConf, Map<Object, Object> properties) {
        if (properties instanceof Properties) {
            Properties props = (Properties)properties;
            Set<String> keys = props.stringPropertyNames();
            for (String key : keys) {
                jobConf.set(key, props.getProperty(key));
            }
        } else {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                if (entry.getValue() == null) continue;
                jobConf.set(entry.getKey().toString(), entry.getValue().toString());
            }
        }
    }

    public PlannerInfo getPlannerInfo(String registryName) {
        return new PlannerInfo(((Object)((Object)this)).getClass().getSimpleName(), PLATFORM_NAME, registryName);
    }

    public JobConf getDefaultConfig() {
        return this.defaultJobConf;
    }

    public PlatformInfo getPlatformInfo() {
        return HadoopUtil.getPlatformInfo(JobConf.class, (String)"org/apache/hadoop", (String)"Hadoop MR");
    }

    public void initialize(FlowConnector flowConnector, Map<Object, Object> properties) {
        super.initialize(flowConnector, properties);
        this.defaultJobConf = HadoopUtil.createJobConf(properties, (JobConf)HadoopPlanner.createJobConf(properties));
        this.checkPlatform((Configuration)this.defaultJobConf);
        this.intermediateSchemeClass = flowConnector.getIntermediateSchemeClass(properties);
        Class type = AppProps.getApplicationJarClass(properties);
        if (this.defaultJobConf.getJar() == null && type != null) {
            this.defaultJobConf.setJarByClass(type);
        }
        String path = AppProps.getApplicationJarPath(properties);
        if (this.defaultJobConf.getJar() == null && path != null) {
            this.defaultJobConf.setJar(path);
        }
        if (this.defaultJobConf.getJar() == null) {
            this.defaultJobConf.setJarByClass(HadoopUtil.findMainClass(HadoopPlanner.class));
        }
        AppProps.setApplicationJarPath(properties, (String)this.defaultJobConf.getJar());
        LOG.info("using application jar: {}", (Object)this.defaultJobConf.getJar());
    }

    public void configRuleRegistryDefaults(RuleRegistry ruleRegistry) {
        super.configRuleRegistryDefaults(ruleRegistry);
        ruleRegistry.addDefaultElementFactory("cascading.registry.tap.intermediate", (ElementFactory)new FlowPlanner.TempTapElementFactory((FlowPlanner)this));
        if (PropertyUtil.getBooleanProperty((Map)this.getDefaultProperties(), (String)"cascading.flowconnector.accumulated_tap.decorator.enable", (boolean)true)) {
            ruleRegistry.addDefaultElementFactory("cascading.registry.tap.accumulated", (ElementFactory)new FlowPlanner.TempTapElementFactory((FlowPlanner)this, DistCacheTap.class.getName()));
        }
    }

    protected void checkPlatform(Configuration conf) {
        if (HadoopUtil.isYARN((Configuration)conf)) {
            LOG.warn("running YARN based flows on Hadoop 1.x may cause problems, please use the 'cascading-hadoop2-mr1' dependencies");
        }
    }

    protected HadoopFlow createFlow(FlowDef flowDef) {
        return new HadoopFlow(this.getPlatformInfo(), this.getDefaultProperties(), this.getDefaultConfig(), flowDef);
    }

    public FlowStepFactory<JobConf> getFlowStepFactory() {
        return new BaseFlowStepFactory<JobConf>(this.getFlowNodeFactory()){

            public FlowStep<JobConf> createFlowStep(ElementGraph stepElementGraph, FlowNodeGraph flowNodeGraph) {
                return new HadoopFlowStep(stepElementGraph, flowNodeGraph);
            }
        };
    }

    public URI getDefaultURIScheme(Tap tap) {
        return ((Hfs)tap).getDefaultFileSystemURIScheme((Configuration)this.defaultJobConf);
    }

    public URI getURIScheme(Tap tap) {
        return ((Hfs)tap).getURIScheme((Configuration)this.defaultJobConf);
    }

    protected Tap makeTempTap(String prefix, String name) {
        return new TempHfs((Configuration)this.defaultJobConf, Util.makePath((String)prefix, (String)name), this.intermediateSchemeClass, prefix == null);
    }
}

