/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.hadoop.planner;

import cascading.flow.FlowException;
import cascading.flow.FlowStep;
import cascading.flow.hadoop.HadoopFlowStep;
import cascading.flow.planner.BaseFlowStep;
import cascading.flow.planner.FlowStepJob;
import cascading.management.state.ClientState;
import cascading.stats.FlowNodeStats;
import cascading.stats.FlowStepStats;
import cascading.stats.hadoop.HadoopStepStats;
import java.io.IOException;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskCompletionEvent;

public class HadoopFlowStepJob
extends FlowStepJob<JobConf> {
    private static Throwable localError;
    protected JobClient jobClient;
    protected RunningJob runningJob;

    private static long getStoreInterval(JobConf jobConf) {
        return jobConf.getLong("cascading.stats.store.interval", 60000L);
    }

    private static long getChildDetailsBlockingDuration(JobConf jobConf) {
        return jobConf.getLong("cascading.stats.complete_child_details.block.duration", 60000L);
    }

    public static long getJobPollingInterval(JobConf jobConf) {
        return jobConf.getLong("cascading.flow.job.pollinginterval", 5000L);
    }

    public HadoopFlowStepJob(ClientState clientState, BaseFlowStep<JobConf> flowStep, JobConf currentConf) {
        super(clientState, (Object)currentConf, flowStep, HadoopFlowStepJob.getJobPollingInterval(currentConf), HadoopFlowStepJob.getStoreInterval(currentConf), HadoopFlowStepJob.getChildDetailsBlockingDuration(currentConf));
        if (flowStep.isDebugEnabled()) {
            flowStep.logDebug("using polling interval: " + this.pollingInterval, new Object[0]);
        }
    }

    protected FlowStepStats createStepStats(ClientState clientState) {
        return new HadoopStepStats((FlowStep)this.flowStep, clientState){

            @Override
            public JobClient getJobClient() {
                return HadoopFlowStepJob.this.jobClient;
            }

            public RunningJob getJobStatusClient() {
                return HadoopFlowStepJob.this.runningJob;
            }
        };
    }

    protected void internalBlockOnStop() throws IOException {
        if (this.runningJob != null && !this.runningJob.isComplete()) {
            this.runningJob.killJob();
        }
    }

    protected void internalNonBlockingStart() throws IOException {
        this.jobClient = new JobClient((JobConf)this.jobConfiguration);
        this.runningJob = this.internalNonBlockingSubmit();
        this.flowStep.logInfo("submitted hadoop job: " + this.runningJob.getID(), new Object[0]);
        if (this.runningJob.getTrackingURL() != null) {
            this.flowStep.logInfo("tracking url: " + this.runningJob.getTrackingURL(), new Object[0]);
        }
    }

    protected RunningJob internalNonBlockingSubmit() throws IOException {
        return this.jobClient.submitJob((JobConf)this.jobConfiguration);
    }

    protected void updateNodeStatus(FlowNodeStats flowNodeStats) {
        try {
            if (this.runningJob == null || flowNodeStats.isFinished()) {
                return;
            }
            boolean isMapper = flowNodeStats.getOrdinal() == 0;
            Integer jobState = this.getJobStateSafe();
            if (jobState == null) {
                return;
            }
            if (JobStatus.FAILED == jobState) {
                flowNodeStats.markFailed();
                return;
            }
            if (JobStatus.KILLED == jobState) {
                flowNodeStats.markStopped();
                return;
            }
            float progress = isMapper ? this.runningJob.mapProgress() : this.runningJob.reduceProgress();
            if (progress == 0.0f) {
                return;
            }
            if (progress != 1.0f) {
                flowNodeStats.markRunning();
                return;
            }
            flowNodeStats.markRunning();
            if (isMapper && this.runningJob.reduceProgress() > 0.0f) {
                flowNodeStats.markSuccessful();
                return;
            }
            if (JobStatus.SUCCEEDED == jobState) {
                flowNodeStats.markSuccessful();
            }
        }
        catch (IOException exception) {
            this.flowStep.logError("failed setting node status", this.throwable);
        }
    }

    private Integer getJobStateSafe() throws IOException {
        try {
            return this.runningJob.getJobState();
        }
        catch (NullPointerException exception) {
            return null;
        }
    }

    public boolean isSuccessful() {
        try {
            return super.isSuccessful();
        }
        catch (NullPointerException exception) {
            throw new FlowException("Hadoop is not keeping a large enough job history, please increase the 'mapred.jobtracker.completeuserjobs.maximum' property", (Throwable)exception);
        }
    }

    protected boolean internalNonBlockingIsSuccessful() throws IOException {
        return this.runningJob != null && this.runningJob.isSuccessful();
    }

    protected boolean isRemoteExecution() {
        return !((HadoopFlowStep)this.flowStep).isHadoopLocalMode((JobConf)this.getConfig());
    }

    protected Throwable getThrowable() {
        return localError;
    }

    protected String internalJobId() {
        return this.runningJob.getJobID();
    }

    protected boolean internalNonBlockingIsComplete() throws IOException {
        return this.runningJob.isComplete();
    }

    protected void dumpDebugInfo() {
        try {
            if (this.runningJob == null) {
                return;
            }
            Integer jobState = this.getJobStateSafe();
            if (jobState == null) {
                return;
            }
            this.flowStep.logWarn("hadoop job " + this.runningJob.getID() + " state at " + JobStatus.getJobRunState((int)jobState));
            this.flowStep.logWarn("failure info: " + this.runningJob.getFailureInfo());
            TaskCompletionEvent[] events = this.runningJob.getTaskCompletionEvents(0);
            this.flowStep.logWarn("task completion events identify failed tasks");
            this.flowStep.logWarn("task completion events count: " + events.length);
            for (TaskCompletionEvent event : events) {
                this.flowStep.logWarn("event = " + event);
            }
        }
        catch (Throwable throwable) {
            this.flowStep.logError("failed reading task completion events", throwable);
        }
    }

    protected boolean internalIsStartedRunning() {
        if (this.runningJob == null) {
            return false;
        }
        try {
            return this.runningJob.mapProgress() > 0.0f;
        }
        catch (IOException exception) {
            this.flowStep.logWarn("unable to test for map progress", (Throwable)exception);
            return false;
        }
    }

    public static void reportLocalError(Throwable throwable) {
        localError = throwable;
    }
}

