/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.hadoop;

import cascading.CascadingException;
import cascading.flow.FlowProcess;
import cascading.flow.FlowSession;
import cascading.flow.hadoop.MapRed;
import cascading.flow.hadoop.util.HadoopUtil;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.TupleEntryIterator;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.ReflectionUtils;

public class HadoopFlowProcess
extends FlowProcess<JobConf>
implements MapRed {
    final JobConf jobConf;
    private final boolean isMapper;
    Reporter reporter = Reporter.NULL;
    private OutputCollector outputCollector;

    public HadoopFlowProcess() {
        this.jobConf = new JobConf();
        this.isMapper = true;
    }

    public HadoopFlowProcess(Configuration jobConf) {
        this(new JobConf(jobConf));
    }

    public HadoopFlowProcess(JobConf jobConf) {
        this.jobConf = jobConf;
        this.isMapper = true;
    }

    public HadoopFlowProcess(FlowSession flowSession, JobConf jobConf) {
        super(flowSession);
        this.jobConf = jobConf;
        this.isMapper = true;
    }

    public HadoopFlowProcess(FlowSession flowSession, JobConf jobConf, boolean isMapper) {
        super(flowSession);
        this.jobConf = jobConf;
        this.isMapper = isMapper;
    }

    public HadoopFlowProcess(HadoopFlowProcess flowProcess, JobConf jobConf) {
        super((FlowProcess)flowProcess);
        this.jobConf = jobConf;
        this.isMapper = flowProcess.isMapper();
        this.reporter = flowProcess.getReporter();
    }

    public FlowProcess copyWith(JobConf jobConf) {
        return new HadoopFlowProcess(this, jobConf);
    }

    public JobConf getJobConf() {
        return this.jobConf;
    }

    public JobConf getConfig() {
        return this.jobConf;
    }

    public JobConf getConfigCopy() {
        return HadoopUtil.copyJobConf((JobConf)this.jobConf);
    }

    public boolean isMapper() {
        return this.isMapper;
    }

    public int getCurrentNumMappers() {
        return this.getJobConf().getNumMapTasks();
    }

    public int getCurrentNumReducers() {
        return this.getJobConf().getNumReduceTasks();
    }

    public int getCurrentSliceNum() {
        return this.getJobConf().getInt("mapred.task.partition", 0);
    }

    public int getNumProcessSlices() {
        if (this.isMapper()) {
            return this.getCurrentNumMappers();
        }
        return this.getCurrentNumReducers();
    }

    public void setReporter(Reporter reporter) {
        this.reporter = reporter == null ? Reporter.NULL : reporter;
    }

    public Reporter getReporter() {
        return this.reporter;
    }

    public void setOutputCollector(OutputCollector outputCollector) {
        this.outputCollector = outputCollector;
    }

    public OutputCollector getOutputCollector() {
        return this.outputCollector;
    }

    public Object getProperty(String key) {
        return this.jobConf.get(key);
    }

    public Collection<String> getPropertyKeys() {
        HashSet keys = new HashSet();
        for (Map.Entry entry : this.jobConf) {
            keys.add(entry.getKey());
        }
        return Collections.unmodifiableSet(keys);
    }

    public Object newInstance(String className) {
        if (className == null || className.isEmpty()) {
            return null;
        }
        try {
            Class<?> type = HadoopFlowProcess.class.getClassLoader().loadClass(className.toString());
            return ReflectionUtils.newInstance(type, (Configuration)this.jobConf);
        }
        catch (ClassNotFoundException exception) {
            throw new CascadingException("unable to load class: " + className.toString(), (Throwable)exception);
        }
    }

    public void keepAlive() {
        this.getReporter().progress();
    }

    public void increment(Enum counter, long amount) {
        this.getReporter().incrCounter(counter, amount);
    }

    public void increment(String group, String counter, long amount) {
        this.getReporter().incrCounter(group, counter, amount);
    }

    public long getCounterValue(Enum counter) {
        return this.getReporter().getCounter(counter).getValue();
    }

    public long getCounterValue(String group, String counter) {
        return this.getReporter().getCounter(group, counter).getValue();
    }

    public void setStatus(String status) {
        this.getReporter().setStatus(status);
    }

    public boolean isCounterStatusInitialized() {
        return this.getReporter() != null;
    }

    public TupleEntryIterator openTapForRead(Tap tap) throws IOException {
        return tap.openForRead((FlowProcess)this);
    }

    public TupleEntryCollector openTapForWrite(Tap tap) throws IOException {
        return tap.openForWrite((FlowProcess)this, null);
    }

    public TupleEntryCollector openTrapForWrite(Tap trap) throws IOException {
        JobConf jobConf = HadoopUtil.copyJobConf((JobConf)this.getJobConf());
        int stepNum = jobConf.getInt("cascading.flow.step.num", 0);
        String partname = jobConf.getBoolean("mapred.task.is.map", true) ? String.format("-m-%05d-", stepNum) : String.format("-r-%05d-", stepNum);
        jobConf.set("cascading.tapcollector.partname", "%s%spart" + partname + "%05d");
        return trap.openForWrite((FlowProcess)new HadoopFlowProcess(this, jobConf), null);
    }

    public TupleEntryCollector openSystemIntermediateForWrite() throws IOException {
        return new TupleEntryCollector(Fields.size((int)2)){

            protected void collect(TupleEntry tupleEntry) {
                try {
                    HadoopFlowProcess.this.getOutputCollector().collect(tupleEntry.getObject(0), tupleEntry.getObject(1));
                }
                catch (IOException exception) {
                    throw new CascadingException("failed collecting key and value", (Throwable)exception);
                }
            }
        };
    }

    public <C> C copyConfig(C config) {
        return (C)HadoopUtil.copyJobConf(config);
    }

    public <C> Map<String, String> diffConfigIntoMap(C defaultConfig, C updatedConfig) {
        return HadoopUtil.getConfig((Configuration)((Configuration)defaultConfig), (Configuration)((Configuration)updatedConfig));
    }

    public JobConf mergeMapIntoConfig(JobConf defaultConfig, Map<String, String> map) {
        return (JobConf)HadoopUtil.mergeConf((Configuration)defaultConfig, map, (boolean)false);
    }
}

