/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.hadoop;

import cascading.flow.BaseFlow;
import cascading.flow.Flow;
import cascading.flow.FlowDef;
import cascading.flow.FlowException;
import cascading.flow.FlowProcess;
import cascading.flow.FlowStep;
import cascading.flow.hadoop.HadoopFlowProcess;
import cascading.flow.hadoop.util.HadoopMRUtil;
import cascading.flow.hadoop.util.HadoopUtil;
import cascading.flow.planner.BaseFlowStep;
import cascading.flow.planner.PlatformInfo;
import cascading.property.PropertyUtil;
import cascading.tap.hadoop.io.HttpFileSystem;
import cascading.util.ShutdownUtil;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import riffle.process.ProcessConfiguration;

public class HadoopFlow
extends BaseFlow<JobConf> {
    private static Thread hdfsShutdown = null;
    private static ShutdownUtil.Hook shutdownHook;
    private transient JobConf jobConf;
    private boolean preserveTemporaryFiles = false;
    private transient Map<Path, Path> syncPaths;

    protected HadoopFlow() {
    }

    static boolean getPreserveTemporaryFiles(Map<Object, Object> properties) {
        return Boolean.parseBoolean((String)PropertyUtil.getProperty(properties, (String)"cascading.flow.preservetemporaryfiles", (Object)"false"));
    }

    static int getMaxConcurrentSteps(JobConf jobConf) {
        return jobConf.getInt("cascading.flow.maxconcurrentsteps", 0);
    }

    protected HadoopFlow(PlatformInfo platformInfo, Map<Object, Object> properties, JobConf jobConf, String name, Map<String, String> flowDescriptor) {
        super(platformInfo, properties, (Object)jobConf, name, flowDescriptor);
        this.initFromProperties(properties);
    }

    public HadoopFlow(PlatformInfo platformInfo, Map<Object, Object> properties, JobConf jobConf, FlowDef flowDef) {
        super(platformInfo, properties, (Object)jobConf, flowDef);
        this.initFromProperties(properties);
    }

    protected void initFromProperties(Map<Object, Object> properties) {
        super.initFromProperties(properties);
        this.preserveTemporaryFiles = HadoopFlow.getPreserveTemporaryFiles(properties);
    }

    protected void initConfig(Map<Object, Object> properties, JobConf parentConfig) {
        if (properties != null) {
            parentConfig = (JobConf)this.createConfig(properties, parentConfig);
        }
        if (parentConfig == null) {
            return;
        }
        this.jobConf = HadoopUtil.copyJobConf((JobConf)parentConfig);
        this.jobConf.set("fs.http.impl", HttpFileSystem.class.getName());
        this.jobConf.set("fs.https.impl", HttpFileSystem.class.getName());
        this.syncPaths = HadoopMRUtil.addToClassPath((Configuration)this.jobConf, this.getClassPath());
    }

    protected void setConfigProperty(JobConf config, Object key, Object value) {
        if (value instanceof Class || value instanceof JobConf || value == null) {
            return;
        }
        config.set(key.toString(), value.toString());
    }

    protected JobConf newConfig(JobConf defaultConfig) {
        return defaultConfig == null ? new JobConf() : HadoopUtil.copyJobConf((JobConf)defaultConfig);
    }

    @ProcessConfiguration
    public JobConf getConfig() {
        if (this.jobConf == null) {
            this.initConfig(null, new JobConf());
        }
        return this.jobConf;
    }

    public JobConf getConfigCopy() {
        return HadoopUtil.copyJobConf((JobConf)this.getConfig());
    }

    public Map<Object, Object> getConfigAsProperties() {
        return HadoopUtil.createProperties((Configuration)this.getConfig());
    }

    public String getProperty(String key) {
        return this.getConfig().get(key);
    }

    public FlowProcess<JobConf> getFlowProcess() {
        return new HadoopFlowProcess(this.getFlowSession(), this.getConfig());
    }

    public boolean isPreserveTemporaryFiles() {
        return this.preserveTemporaryFiles;
    }

    protected void internalStart() {
        try {
            this.copyToDistributedCache();
            this.deleteSinksIfReplace();
            this.deleteTrapsIfReplace();
            this.deleteCheckpointsIfReplace();
        }
        catch (IOException exception) {
            throw new FlowException("unable to delete sinks", (Throwable)exception);
        }
        this.registerHadoopShutdownHook();
    }

    protected void registerHadoopShutdownHook() {
        HadoopFlow.registerHadoopShutdownHook((Flow)this);
    }

    protected void copyToDistributedCache() {
        HadoopUtil.syncPaths((Configuration)this.jobConf, this.syncPaths, (boolean)true);
    }

    public boolean stepsAreLocal() {
        return HadoopUtil.isLocal((Configuration)this.getConfig());
    }

    private void cleanTemporaryFiles(boolean stop) {
        if (stop) {
            return;
        }
        for (FlowStep step : this.getFlowSteps()) {
            ((BaseFlowStep)step).clean();
        }
    }

    private static synchronized void registerHadoopShutdownHook(Flow flow) {
        if (!flow.isStopJobsOnExit()) {
            return;
        }
        if (shutdownHook != null) {
            return;
        }
        HadoopFlow.getHdfsShutdownHook();
        shutdownHook = new ShutdownUtil.Hook(){

            public ShutdownUtil.Hook.Priority priority() {
                return ShutdownUtil.Hook.Priority.LAST;
            }

            public void execute() {
                HadoopFlow.callHdfsShutdownHook();
            }
        };
        ShutdownUtil.addHook((ShutdownUtil.Hook)shutdownHook);
    }

    private static synchronized void callHdfsShutdownHook() {
        if (hdfsShutdown != null) {
            hdfsShutdown.start();
        }
    }

    private static synchronized void getHdfsShutdownHook() {
        if (hdfsShutdown == null) {
            hdfsShutdown = HadoopUtil.getHDFSShutdownHook();
        }
    }

    protected void internalClean(boolean stop) {
        if (!this.isPreserveTemporaryFiles()) {
            this.cleanTemporaryFiles(stop);
        }
    }

    protected void internalShutdown() {
    }

    protected int getMaxNumParallelSteps() {
        return this.stepsAreLocal() ? 1 : HadoopFlow.getMaxConcurrentSteps(this.getConfig());
    }

    protected long getTotalSliceCPUMilliSeconds() {
        long counterValue = this.flowStats.getCounterValue("org.apache.hadoop.mapreduce.TaskCounter", "CPU_MILLISECONDS");
        if (counterValue == 0L) {
            return -1L;
        }
        return counterValue;
    }
}

