/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.hadoop;

import cascading.CascadingTestCase;
import cascading.flow.FlowProcess;
import cascading.flow.hadoop.HadoopFlowProcess;
import cascading.scheme.Scheme;
import cascading.scheme.hadoop.TextDelimited;
import cascading.tap.hadoop.Hfs;
import cascading.tap.hadoop.PartitionTap;
import cascading.tap.partition.DelimitedPartition;
import cascading.tap.partition.Partition;
import cascading.tuple.Fields;
import java.io.IOException;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.junit.Test;

public class PartitionTapTest
extends CascadingTestCase {
    @Test
    public void testPartitionTap() throws IOException {
        String comment = "improved";
        long ts = System.currentTimeMillis();
        this.getDuration(100);
        int runs = 4;
        int[] sizes = new int[]{1, 10, 100, 1000, 10000};
        long[][] durations = new long[sizes.length][runs];
        for (int run = 0; run < runs; ++run) {
            for (int i = 0; i < sizes.length; ++i) {
                durations[i][run] = this.getDuration(sizes[i]);
            }
        }
        for (int i = 0; i < durations.length; ++i) {
            long[] duration = durations[i];
            DescriptiveStatistics stats = new DescriptiveStatistics();
            for (long value : duration) {
                stats.addValue((double)value);
            }
            String string = String.format("%s,%d,%d,%f\n", comment, ts, sizes[i], stats.getMean());
            System.out.print(string);
        }
    }

    public long getDuration(int size) {
        long start = System.currentTimeMillis();
        this.createPartitionTap(size).sourceConfInit((FlowProcess)new HadoopFlowProcess(new JobConf()), (Configuration)new JobConf());
        return System.currentTimeMillis() - start;
    }

    protected PartitionTap createPartitionTap(int size) {
        String path = "some/path/that/is/particularly/long/and/unwieldy/";
        final String[] values = new String[size];
        for (int i = 0; i < values.length; ++i) {
            values[i] = "some/path/that/is/particularly/long/and/unwieldy/" + i;
        }
        return new PartitionTap(new Hfs((Scheme)new TextDelimited(new Fields(new Comparable[]{"foo"}), ","), "some/path/that/is/particularly/long/and/unwieldy/"), (Partition)new DelimitedPartition(new Fields(new Comparable[]{"foo"}))){

            public String[] getChildPartitionIdentifiers(FlowProcess<? extends Configuration> flowProcess, boolean fullyQualified) throws IOException {
                return values;
            }
        };
    }
}

