/*
 * Decompiled with CFR 0.152.
 */
package cascading.platform.hadoop2;

import cascading.flow.FlowConnector;
import cascading.flow.FlowProcess;
import cascading.flow.FlowProps;
import cascading.flow.FlowSession;
import cascading.flow.hadoop.HadoopFlowProcess;
import cascading.flow.hadoop2.Hadoop2MR1FlowConnector;
import cascading.flow.hadoop2.Hadoop2MR1Planner;
import cascading.platform.hadoop.BaseHadoopPlatform;
import cascading.tap.Tap;
import cascading.tap.hadoop.DistCacheTap;
import cascading.tap.hadoop.Hfs;
import cascading.util.Util;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRClientCluster;
import org.apache.hadoop.mapred.MiniMRClientClusterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hadoop2MR1Platform
extends BaseHadoopPlatform<JobConf> {
    private static final Logger LOG = LoggerFactory.getLogger(Hadoop2MR1Platform.class);
    private static transient MiniDFSCluster dfs;
    private static transient MiniMRClientCluster mr;

    public String getName() {
        return "hadoop2-mr1";
    }

    public FlowConnector getFlowConnector(Map<Object, Object> properties) {
        return new Hadoop2MR1FlowConnector(properties);
    }

    public void setNumMapTasks(Map<Object, Object> properties, int numMapTasks) {
        properties.put("mapreduce.job.maps", Integer.toString(numMapTasks));
    }

    public void setNumReduceTasks(Map<Object, Object> properties, int numReduceTasks) {
        properties.put("mapreduce.job.reduces", Integer.toString(numReduceTasks));
    }

    public Integer getNumMapTasks(Map<Object, Object> properties) {
        if (properties.get("mapreduce.job.maps") == null) {
            return null;
        }
        return Integer.parseInt(properties.get("mapreduce.job.maps").toString());
    }

    public Integer getNumReduceTasks(Map<Object, Object> properties) {
        if (properties.get("mapreduce.job.reduces") == null) {
            return null;
        }
        return Integer.parseInt(properties.get("mapreduce.job.reduces").toString());
    }

    public JobConf getConfiguration() {
        return new JobConf(configuration);
    }

    public Tap getDistCacheTap(Hfs parent) {
        return new DistCacheTap(parent);
    }

    public FlowProcess getFlowProcess() {
        return new HadoopFlowProcess(FlowSession.NULL, this.getConfiguration(), true);
    }

    public synchronized void setUp() throws IOException {
        if (configuration != null) {
            return;
        }
        if (!this.isUseCluster()) {
            LOG.info("not using cluster");
            configuration = new JobConf();
            configuration.set("fs.defaultFS", "file:///");
            configuration.set("mapreduce.framework.name", "local");
            configuration.set("mapreduce.jobtracker.staging.root.dir", System.getProperty("user.dir") + "/build/tmp/cascading/staging");
            String stagingDir = configuration.get("mapreduce.jobtracker.staging.root.dir");
            if (Util.isEmpty((String)stagingDir)) {
                configuration.set("mapreduce.jobtracker.staging.root.dir", System.getProperty("user.dir") + "/build/tmp/cascading/staging");
            }
            fileSys = FileSystem.get((Configuration)configuration);
        } else {
            LOG.info("using cluster");
            if (Util.isEmpty((String)System.getProperty("hadoop.log.dir"))) {
                System.setProperty("hadoop.log.dir", "build/test/log");
            }
            if (Util.isEmpty((String)System.getProperty("hadoop.tmp.dir"))) {
                System.setProperty("hadoop.tmp.dir", "build/test/tmp");
            }
            new File(System.getProperty("hadoop.log.dir")).mkdirs();
            JobConf conf = new JobConf();
            if (this.getApplicationJar() != null) {
                LOG.info("using a remote cluster with jar: {}", (Object)this.getApplicationJar());
                configuration = conf;
                ((JobConf)configuration).setJar(this.getApplicationJar());
                if (!Util.isEmpty((String)System.getProperty("fs.default.name"))) {
                    LOG.info("using {}={}", (Object)"fs.default.name", (Object)System.getProperty("fs.default.name"));
                    configuration.set("fs.default.name", System.getProperty("fs.default.name"));
                }
                if (!Util.isEmpty((String)System.getProperty("mapred.job.tracker"))) {
                    LOG.info("using {}={}", (Object)"mapred.job.tracker", (Object)System.getProperty("mapred.job.tracker"));
                    configuration.set("mapred.job.tracker", System.getProperty("mapred.job.tracker"));
                }
                if (!Util.isEmpty((String)System.getProperty("fs.defaultFS"))) {
                    LOG.info("using {}={}", (Object)"fs.defaultFS", (Object)System.getProperty("fs.defaultFS"));
                    configuration.set("fs.defaultFS", System.getProperty("fs.defaultFS"));
                }
                if (!Util.isEmpty((String)System.getProperty("yarn.resourcemanager.address"))) {
                    LOG.info("using {}={}", (Object)"yarn.resourcemanager.address", (Object)System.getProperty("yarn.resourcemanager.address"));
                    configuration.set("yarn.resourcemanager.address", System.getProperty("yarn.resourcemanager.address"));
                }
                if (!Util.isEmpty((String)System.getProperty("mapreduce.jobhistory.address"))) {
                    LOG.info("using {}={}", (Object)"mapreduce.jobhistory.address", (Object)System.getProperty("mapreduce.jobhistory.address"));
                    configuration.set("mapreduce.jobhistory.address", System.getProperty("mapreduce.jobhistory.address"));
                }
                configuration.set("mapreduce.job.user.classpath.first", "true");
                configuration.set("mapreduce.user.classpath.first", "true");
                configuration.set("mapreduce.framework.name", "yarn");
                fileSys = FileSystem.get((Configuration)configuration);
            } else {
                conf.setBoolean("yarn.is.minicluster", true);
                conf.setBoolean("yarn.app.mapreduce.am.job.node-blacklisting.enable", false);
                dfs = new MiniDFSCluster((Configuration)conf, 4, true, null);
                fileSys = dfs.getFileSystem();
                FileSystem.setDefaultUri((Configuration)conf, (URI)fileSys.getUri());
                mr = MiniMRClientClusterFactory.create(((Object)((Object)this)).getClass(), (int)4, (Configuration)conf);
                configuration = mr.getConfig();
            }
            configuration.set("mapred.child.java.opts", "-Xmx512m");
            configuration.setInt("mapreduce.job.jvm.numtasks", -1);
            configuration.setInt("mapreduce.client.completion.pollinterval", 50);
            configuration.setInt("mapreduce.client.progressmonitor.pollinterval", 50);
            configuration.setBoolean("mapreduce.map.speculative", false);
            configuration.setBoolean("mapreduce.reduce.speculative", false);
        }
        configuration.setInt("mapreduce.job.maps", this.numMappers);
        configuration.setInt("mapreduce.job.reduces", this.numReducers);
        Map globalProperties = Hadoop2MR1Platform.getGlobalProperties();
        if (this.logger != null) {
            globalProperties.put("log4j.logger", this.logger);
        }
        FlowProps.setJobPollingInterval((Map)globalProperties, (long)10L);
        Hadoop2MR1Planner.copyProperties((Configuration)configuration, (Map)globalProperties);
        Hadoop2MR1Planner.copyConfiguration((Map)properties, (Configuration)configuration);
    }
}

