/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop.io;

import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.hadoop.TupleSerialization;
import cascading.tuple.hadoop.io.HadoopTupleOutputStream;
import cascading.tuple.io.TupleOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.io.serializer.Serializer;

abstract class BaseSerializer<T extends Tuple>
implements Serializer<T> {
    private final TupleSerialization.SerializationElementWriter elementWriter;
    private TupleOutputStream.TupleElementWriter[] writers;
    HadoopTupleOutputStream outputStream;

    protected BaseSerializer(TupleSerialization.SerializationElementWriter elementWriter) {
        this.elementWriter = elementWriter;
    }

    protected void setWriters(Fields fields) {
        if (fields == null) {
            return;
        }
        Class[] classes = this.elementWriter.getTupleSerialization().getTypesFor(fields);
        if (this.elementWriter.getTupleSerialization().areTypesRequired() && classes == null) {
            throw new IllegalStateException("types are required to perform serialization, declared fields: " + fields);
        }
        this.writers = HadoopTupleOutputStream.getWritersFor(this.elementWriter, classes);
    }

    public void open(OutputStream out) {
        this.outputStream = out instanceof HadoopTupleOutputStream ? (HadoopTupleOutputStream)((Object)out) : new HadoopTupleOutputStream(out, this.elementWriter);
    }

    public void serialize(T tuple) throws IOException {
        if (this.writers == null) {
            this.outputStream.writeUnTyped((Tuple)tuple);
        } else {
            this.outputStream.writeWith(this.writers, (Tuple)tuple);
        }
    }

    public void close() throws IOException {
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
        finally {
            this.outputStream = null;
        }
    }
}

