/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop.collect;

import cascading.flow.FlowProcess;
import cascading.tuple.Tuple;
import cascading.tuple.collect.SpillableTupleList;
import cascading.tuple.collect.TupleCollectionFactory;
import cascading.tuple.hadoop.TupleSerialization;
import cascading.tuple.hadoop.collect.HadoopSpillableTupleList;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;

public class HadoopTupleCollectionFactory
implements TupleCollectionFactory<Configuration> {
    private int spillThreshold;
    private CompressionCodec codec;
    private TupleSerialization tupleSerialization;

    public void initialize(FlowProcess<? extends Configuration> flowProcess) {
        this.spillThreshold = SpillableTupleList.getThreshold(flowProcess, (int)10000);
        this.codec = HadoopSpillableTupleList.getCodec(flowProcess, "org.apache.hadoop.io.compress.GzipCodec,org.apache.hadoop.io.compress.DefaultCodec");
        this.tupleSerialization = new TupleSerialization(flowProcess);
    }

    public Collection<Tuple> create(FlowProcess<? extends Configuration> flowProcess) {
        return new HadoopSpillableTupleList(this.spillThreshold, this.tupleSerialization, this.codec);
    }
}

