/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.hadoop.io;

import cascading.flow.FlowProcess;
import cascading.flow.hadoop.MapRed;
import cascading.flow.hadoop.util.HadoopUtil;
import cascading.tap.Tap;
import cascading.tap.TapException;
import cascading.util.CloseableIterator;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiRecordReaderIterator
implements CloseableIterator<RecordReader> {
    private static final Logger LOG = LoggerFactory.getLogger(MultiRecordReaderIterator.class);
    private final FlowProcess<? extends Configuration> flowProcess;
    private final Tap tap;
    private InputFormat inputFormat;
    private Configuration conf;
    private InputSplit[] splits;
    private RecordReader reader;
    private RecordReader lastReader;
    private int currentSplit = 0;
    private boolean complete = false;

    public MultiRecordReaderIterator(FlowProcess<? extends Configuration> flowProcess, Tap tap) throws IOException {
        this.flowProcess = flowProcess;
        this.tap = tap;
        this.conf = (Configuration)flowProcess.getConfigCopy();
        this.initialize();
    }

    private void initialize() throws IOException {
        String property = this.flowProcess.getStringProperty("cascading.node.accumulated.source.conf." + Tap.id((Tap)this.tap));
        if (property == null) {
            this.conf = HadoopUtil.removePropertiesFrom(this.conf, "mapred.input.dir", "mapreduce.input.fileinputformat.inputdir");
            this.tap.sourceConfInit(this.flowProcess, (Object)this.conf);
        }
        JobConf jobConf = HadoopUtil.asJobConfInstance(this.conf);
        this.inputFormat = jobConf.getInputFormat();
        if (this.inputFormat instanceof JobConfigurable) {
            ((JobConfigurable)this.inputFormat).configure(jobConf);
        }
        this.splits = this.inputFormat.getSplits(jobConf, 1);
        if (this.splits.length == 0) {
            this.complete = true;
        }
    }

    private RecordReader makeReader(int currentSplit) throws IOException {
        LOG.debug("reading split: {}", (Object)currentSplit);
        Reporter reporter = Reporter.NULL;
        if (this.flowProcess instanceof MapRed) {
            reporter = ((MapRed)this.flowProcess).getReporter();
        }
        return this.inputFormat.getRecordReader(this.splits[currentSplit], HadoopUtil.asJobConfInstance(this.conf), reporter);
    }

    public boolean hasNext() {
        this.getNextReader();
        return !this.complete;
    }

    public RecordReader next() {
        if (this.complete) {
            throw new IllegalStateException("no more values");
        }
        try {
            this.getNextReader();
            RecordReader recordReader = this.reader;
            return recordReader;
        }
        finally {
            this.reader = null;
        }
    }

    private void getNextReader() {
        if (this.complete || this.reader != null) {
            return;
        }
        try {
            if (this.currentSplit < this.splits.length) {
                if (this.lastReader != null) {
                    this.lastReader.close();
                }
                this.lastReader = this.reader = this.makeReader(this.currentSplit++);
            } else {
                this.complete = true;
            }
        }
        catch (IOException exception) {
            throw new TapException("could not get next tuple", (Throwable)exception);
        }
    }

    public void remove() {
        throw new UnsupportedOperationException("unimplemented");
    }

    public void close() throws IOException {
        if (this.lastReader != null) {
            this.lastReader.close();
        }
    }
}

