/*
 * Decompiled with CFR 0.152.
 */
package cascading.scheme.hadoop;

import cascading.flow.FlowProcess;
import cascading.scheme.FileFormat;
import cascading.scheme.Scheme;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import java.beans.ConstructorProperties;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;

public class SequenceFile
extends Scheme<Configuration, RecordReader, OutputCollector, Object[], Void>
implements FileFormat {
    protected SequenceFile() {
        super(null);
    }

    @ConstructorProperties(value={"fields"})
    public SequenceFile(Fields fields) {
        super(fields, fields);
    }

    public void sourceConfInit(FlowProcess<? extends Configuration> flowProcess, Tap<Configuration, RecordReader, OutputCollector> tap, Configuration conf) {
        conf.setBoolean("mapred.mapper.new-api", false);
        conf.setClass("mapred.input.format.class", SequenceFileInputFormat.class, InputFormat.class);
    }

    public void sinkConfInit(FlowProcess<? extends Configuration> flowProcess, Tap<Configuration, RecordReader, OutputCollector> tap, Configuration conf) {
        conf.setBoolean("mapred.mapper.new-api", false);
        conf.setClass("mapred.output.key.class", Tuple.class, Object.class);
        conf.setClass("mapred.output.value.class", Tuple.class, Object.class);
        conf.setClass("mapred.output.format.class", SequenceFileOutputFormat.class, OutputFormat.class);
    }

    public void sourcePrepare(FlowProcess<? extends Configuration> flowProcess, SourceCall<Object[], RecordReader> sourceCall) {
        Object[] pair = new Object[]{((RecordReader)sourceCall.getInput()).createKey(), ((RecordReader)sourceCall.getInput()).createValue()};
        sourceCall.setContext((Object)pair);
    }

    public boolean source(FlowProcess<? extends Configuration> flowProcess, SourceCall<Object[], RecordReader> sourceCall) throws IOException {
        Tuple key = (Tuple)((Object[])sourceCall.getContext())[0];
        Tuple value = (Tuple)((Object[])sourceCall.getContext())[1];
        boolean result = ((RecordReader)sourceCall.getInput()).next((Object)key, (Object)value);
        if (!result) {
            return false;
        }
        TupleEntry entry = sourceCall.getIncomingEntry();
        if (entry.hasTypes()) {
            entry.setCanonicalTuple(value);
        } else {
            entry.setTuple(value);
        }
        return true;
    }

    public void sourceCleanup(FlowProcess<? extends Configuration> flowProcess, SourceCall<Object[], RecordReader> sourceCall) {
        sourceCall.setContext(null);
    }

    public void sink(FlowProcess<? extends Configuration> flowProcess, SinkCall<Void, OutputCollector> sinkCall) throws IOException {
        ((OutputCollector)sinkCall.getOutput()).collect((Object)Tuple.NULL, (Object)sinkCall.getOutgoingEntry().getTuple());
    }

    public String getExtension() {
        return "seq";
    }
}

