/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop.io;

import cascading.tuple.hadoop.TupleSerialization;
import cascading.tuple.hadoop.io.BaseSerializer;
import cascading.tuple.hadoop.io.HadoopTupleOutputStream;
import cascading.tuple.io.TupleOutputStream;
import cascading.tuple.io.TuplePair;
import java.io.IOException;

public class TuplePairSerializer
extends BaseSerializer<TuplePair> {
    private final TupleOutputStream.TupleElementWriter[] keyWriters;
    private final TupleOutputStream.TupleElementWriter[] sortWriters;

    public TuplePairSerializer(TupleSerialization.SerializationElementWriter elementWriter) {
        super(elementWriter);
        Class[] keyClasses = elementWriter.getTupleSerialization().getKeyTypes();
        Class[] sortClasses = elementWriter.getTupleSerialization().getSortTypes();
        if (elementWriter.getTupleSerialization().areTypesRequired()) {
            if (keyClasses == null) {
                throw new IllegalStateException("types are required to perform serialization, grouping declared fields: " + elementWriter.getTupleSerialization().getKeyFields());
            }
            if (sortClasses == null) {
                throw new IllegalStateException("types are required to perform serialization, sorting declared fields: " + elementWriter.getTupleSerialization().getSortFields());
            }
        }
        this.keyWriters = HadoopTupleOutputStream.getWritersFor(elementWriter, keyClasses);
        this.sortWriters = HadoopTupleOutputStream.getWritersFor(elementWriter, sortClasses);
    }

    @Override
    public void serialize(TuplePair tuple) throws IOException {
        if (this.keyWriters == null) {
            this.outputStream.writeUnTyped(tuple.getLhs());
        } else {
            this.outputStream.writeWith(this.keyWriters, tuple.getLhs());
        }
        if (this.sortWriters == null) {
            this.outputStream.writeUnTyped(tuple.getRhs());
        } else {
            this.outputStream.writeWith(this.sortWriters, tuple.getRhs());
        }
    }
}

