/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop.io;

import cascading.tuple.hadoop.TupleSerialization;
import cascading.tuple.hadoop.io.BaseSerializer;
import cascading.tuple.io.IndexTuple;
import java.io.IOException;
import java.util.Map;

public class IndexTupleSerializer<T extends IndexTuple>
extends BaseSerializer<T> {
    protected Map<Integer, Class[]> typeMap;

    public IndexTupleSerializer(TupleSerialization.SerializationElementWriter elementWriter) {
        super(elementWriter);
    }

    @Override
    public void serialize(T tuple) throws IOException {
        this.outputStream.writeIntInternal(tuple.getIndex());
        Class[] types = this.getTypesFor(tuple.getIndex());
        if (types == null) {
            this.outputStream.writeUnTyped(tuple.getTuple());
        } else {
            this.outputStream.writeTyped(types, tuple.getTuple());
        }
    }

    protected Class[] getTypesFor(int ordinal) {
        if (this.typeMap == null) {
            return null;
        }
        return this.typeMap.get(ordinal);
    }
}

