/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop;

import cascading.property.Props;
import cascading.util.Util;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class TupleSerializationProps
extends Props {
    public static final String SERIALIZATION_TOKENS = "cascading.serialization.tokens";
    public static final String SERIALIZATION_COMPARISON_BITWISE_PREVENT = "cascading.serialization.comparison.bitwise.prevent";
    public static final String IGNORE_TYPES = "cascading.serialization.types.ignored";
    public static final String REQUIRE_TYPES = "cascading.serialization.types.required";
    public static final String HADOOP_IO_SERIALIZATIONS = "io.serializations";
    Map<Integer, String> serializationTokens = new LinkedHashMap<Integer, String>();
    List<String> hadoopSerializations = new ArrayList<String>();
    Boolean ignoreTypes;
    Boolean requireTypes;
    Boolean preventBitWiseComparisons;

    public static void addSerializationToken(Map<Object, Object> properties, int token, String className) {
        String tokens = TupleSerializationProps.getSerializationTokens(properties);
        properties.put(SERIALIZATION_TOKENS, Util.join((String)",", (String[])Util.removeNulls((String[])new String[]{tokens, token + "=" + className})));
    }

    public static String getSerializationTokens(Map<Object, Object> properties) {
        return (String)properties.get(SERIALIZATION_TOKENS);
    }

    public static void addSerialization(Map<Object, Object> properties, String className) {
        String serializations = (String)properties.get(HADOOP_IO_SERIALIZATIONS);
        properties.put(HADOOP_IO_SERIALIZATIONS, Util.join((String)",", (String[])Util.removeNulls((String[])new String[]{serializations, className})));
    }

    public static TupleSerializationProps tupleSerializationProps() {
        return new TupleSerializationProps();
    }

    public Map<Integer, String> getSerializationTokens() {
        return this.serializationTokens;
    }

    public TupleSerializationProps setSerializationTokens(Map<Integer, String> serializationTokens) {
        this.serializationTokens = serializationTokens;
        return this;
    }

    public TupleSerializationProps addSerializationTokens(Map<Integer, String> serializationTokens) {
        this.serializationTokens.putAll(serializationTokens);
        return this;
    }

    public TupleSerializationProps addSerializationToken(int token, String serializationClassName) {
        this.serializationTokens.put(token, serializationClassName);
        return this;
    }

    public List<String> getHadoopSerializations() {
        return this.hadoopSerializations;
    }

    public TupleSerializationProps setHadoopSerializations(List<String> hadoopSerializationClassNames) {
        this.hadoopSerializations = hadoopSerializationClassNames;
        return this;
    }

    public TupleSerializationProps addHadoopSerializations(List<String> hadoopSerializationClassNames) {
        this.hadoopSerializations.addAll(hadoopSerializationClassNames);
        return this;
    }

    public TupleSerializationProps addHadoopSerialization(String hadoopSerializationClassName) {
        this.hadoopSerializations.add(hadoopSerializationClassName);
        return this;
    }

    public Boolean getIgnoreTypes() {
        return this.ignoreTypes;
    }

    public TupleSerializationProps setIgnoreTypes(Boolean ignoreTypes) {
        this.ignoreTypes = ignoreTypes;
        return this;
    }

    public Boolean getRequireTypes() {
        return this.requireTypes;
    }

    public TupleSerializationProps setRequireTypes(Boolean requireTypes) {
        this.requireTypes = requireTypes;
        return this;
    }

    public TupleSerializationProps preventBitWiseComparison(boolean preventBitWiseComparisons) {
        this.preventBitWiseComparisons = preventBitWiseComparisons;
        return this;
    }

    public boolean getPreventBitWiseComparisons() {
        return this.preventBitWiseComparisons;
    }

    protected void addPropertiesTo(Properties properties) {
        for (Map.Entry<Integer, String> entry : this.serializationTokens.entrySet()) {
            TupleSerializationProps.addSerializationToken(properties, entry.getKey(), entry.getValue());
        }
        for (String hadoopSerialization : this.hadoopSerializations) {
            TupleSerializationProps.addSerialization(properties, hadoopSerialization);
        }
        if (this.ignoreTypes != null) {
            properties.put(IGNORE_TYPES, this.ignoreTypes.toString());
        }
        if (this.requireTypes != null) {
            properties.put(REQUIRE_TYPES, this.requireTypes.toString());
        }
        if (this.preventBitWiseComparisons != null) {
            properties.put(SERIALIZATION_COMPARISON_BITWISE_PREVENT, this.preventBitWiseComparisons.toString());
        }
    }
}

