/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.hadoop.io;

import cascading.flow.FlowProcess;
import cascading.flow.SliceCounters;
import cascading.tap.Tap;
import cascading.tap.hadoop.io.TapOutputCollector;
import cascading.tap.hadoop.util.MeasuredOutputCollector;
import cascading.tuple.TupleEntrySchemeCollector;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;

public class HadoopTupleEntrySchemeCollector
extends TupleEntrySchemeCollector<Configuration, OutputCollector> {
    private MeasuredOutputCollector measuredOutputCollector;

    public HadoopTupleEntrySchemeCollector(FlowProcess<? extends Configuration> flowProcess, Tap<Configuration, RecordReader, OutputCollector> tap) throws IOException {
        super(flowProcess, tap, tap.getScheme(), (Object)HadoopTupleEntrySchemeCollector.makeCollector(flowProcess, tap, null), tap.getIdentifier());
    }

    public HadoopTupleEntrySchemeCollector(FlowProcess<? extends Configuration> flowProcess, Tap<Configuration, RecordReader, OutputCollector> tap, OutputCollector outputCollector) throws IOException {
        super(flowProcess, tap, tap.getScheme(), (Object)HadoopTupleEntrySchemeCollector.makeCollector(flowProcess, tap, outputCollector), tap.getIdentifier());
    }

    private static OutputCollector makeCollector(FlowProcess<? extends Configuration> flowProcess, Tap<Configuration, RecordReader, OutputCollector> tap, OutputCollector outputCollector) throws IOException {
        if (outputCollector != null) {
            return outputCollector;
        }
        return new TapOutputCollector(flowProcess, tap);
    }

    protected OutputCollector<?, ?> wrapOutput(OutputCollector outputCollector) {
        if (this.measuredOutputCollector == null) {
            this.measuredOutputCollector = new MeasuredOutputCollector(this.getFlowProcess(), (Enum)SliceCounters.Write_Duration);
        }
        this.measuredOutputCollector.setOutputCollector((OutputCollector)super.wrapOutput((Object)outputCollector));
        return this.measuredOutputCollector;
    }
}

